'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _utilsTransitionEvents = require('./utils/TransitionEvents');

var _utilsTransitionEvents2 = _interopRequireDefault(_utilsTransitionEvents);

// TODO: This should use a timeout instead of TransitionEvents, or else just
// not wait until transition end to trigger continuing animations.

var propTypes = {
  direction: _react2['default'].PropTypes.oneOf(['prev', 'next']),
  onAnimateOutEnd: _react2['default'].PropTypes.func,
  active: _react2['default'].PropTypes.bool,
  animateIn: _react2['default'].PropTypes.bool,
  animateOut: _react2['default'].PropTypes.bool,
  index: _react2['default'].PropTypes.number
};

var defaultProps = {
  active: false,
  animateIn: false,
  animateOut: false
};

var CarouselItem = (function (_React$Component) {
  _inherits(CarouselItem, _React$Component);

  function CarouselItem(props, context) {
    _classCallCheck(this, CarouselItem);

    _React$Component.call(this, props, context);

    this.handleAnimateOutEnd = this.handleAnimateOutEnd.bind(this);

    this.state = {
      direction: null
    };

    this.isUnmounted = false;
  }

  CarouselItem.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    if (this.props.active !== nextProps.active) {
      this.setState({ direction: null });
    }
  };

  CarouselItem.prototype.componentDidUpdate = function componentDidUpdate(prevProps) {
    var _this = this;

    var active = this.props.active;

    var prevActive = prevProps.active;

    if (!active && prevActive) {
      _utilsTransitionEvents2['default'].addEndEventListener(_reactDom2['default'].findDOMNode(this), this.handleAnimateOutEnd);
    }

    if (active !== prevActive) {
      setTimeout(function () {
        return _this.startAnimation();
      }, 20);
    }
  };

  CarouselItem.prototype.componentWillUnmount = function componentWillUnmount() {
    this.isUnmounted = true;
  };

  CarouselItem.prototype.handleAnimateOutEnd = function handleAnimateOutEnd() {
    if (this.isUnmounted) {
      return;
    }

    if (this.props.onAnimateOutEnd) {
      this.props.onAnimateOutEnd(this.props.index);
    }
  };

  CarouselItem.prototype.startAnimation = function startAnimation() {
    if (this.isUnmounted) {
      return;
    }

    this.setState({
      direction: this.props.direction === 'prev' ? 'right' : 'left'
    });
  };

  CarouselItem.prototype.render = function render() {
    var _props = this.props;
    var direction = _props.direction;
    var active = _props.active;
    var animateIn = _props.animateIn;
    var animateOut = _props.animateOut;
    var className = _props.className;

    var props = _objectWithoutProperties(_props, ['direction', 'active', 'animateIn', 'animateOut', 'className']);

    delete props.onAnimateOutEnd;
    delete props.index;

    var classes = {
      item: true,
      active: active && !animateIn || animateOut
    };
    if (direction && active && animateIn) {
      classes[direction] = true;
    }
    if (this.state.direction && (animateIn || animateOut)) {
      classes[this.state.direction] = true;
    }

    return _react2['default'].createElement('div', _extends({}, props, {
      className: _classnames2['default'](className, classes)
    }));
  };

  return CarouselItem;
})(_react2['default'].Component);

CarouselItem.propTypes = propTypes;
CarouselItem.defaultProps = defaultProps;

exports['default'] = CarouselItem;
module.exports = exports['default'];