'use strict';

var _extends = require('babel-runtime/helpers/extends')['default'];

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Dropdown = require('./Dropdown');

var _Dropdown2 = _interopRequireDefault(_Dropdown);

var _utilsSplitComponentProps = require('./utils/splitComponentProps');

var _utilsSplitComponentProps2 = _interopRequireDefault(_utilsSplitComponentProps);

var propTypes = _extends({}, _Dropdown2['default'].propTypes, {

  // Toggle props.
  bsStyle: _react2['default'].PropTypes.string,
  bsSize: _react2['default'].PropTypes.string,
  title: _react2['default'].PropTypes.node.isRequired,
  noCaret: _react2['default'].PropTypes.bool,

  // Override generated docs from <Dropdown>.
  /**
   * @private
   */
  children: _react2['default'].PropTypes.node
});

var DropdownButton = (function (_React$Component) {
  _inherits(DropdownButton, _React$Component);

  function DropdownButton() {
    _classCallCheck(this, DropdownButton);

    _React$Component.apply(this, arguments);
  }

  DropdownButton.prototype.render = function render() {
    var _props = this.props;
    var bsSize = _props.bsSize;
    var bsStyle = _props.bsStyle;
    var title = _props.title;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['bsSize', 'bsStyle', 'title', 'children']);

    var _splitComponentProps = _utilsSplitComponentProps2['default'](props, _Dropdown2['default'].ControlledComponent);

    var dropdownProps = _splitComponentProps[0];
    var toggleProps = _splitComponentProps[1];

    return _react2['default'].createElement(
      _Dropdown2['default'],
      _extends({}, dropdownProps, {
        bsSize: bsSize,
        bsStyle: bsStyle
      }),
      _react2['default'].createElement(
        _Dropdown2['default'].Toggle,
        _extends({}, toggleProps, {
          bsSize: bsSize,
          bsStyle: bsStyle
        }),
        title
      ),
      _react2['default'].createElement(
        _Dropdown2['default'].Menu,
        null,
        children
      )
    );
  };

  return DropdownButton;
})(_react2['default'].Component);

DropdownButton.propTypes = propTypes;

exports['default'] = DropdownButton;
module.exports = exports['default'];