'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var propTypes = {
  /**
   * Sets image as responsive image
   */
  responsive: _react2['default'].PropTypes.bool,

  /**
   * Sets image shape as rounded
   */
  rounded: _react2['default'].PropTypes.bool,

  /**
   * Sets image shape as circle
   */
  circle: _react2['default'].PropTypes.bool,

  /**
   * Sets image shape as thumbnail
   */
  thumbnail: _react2['default'].PropTypes.bool
};

var defaultProps = {
  responsive: false,
  rounded: false,
  circle: false,
  thumbnail: false
};

var Image = (function (_React$Component) {
  _inherits(Image, _React$Component);

  function Image() {
    _classCallCheck(this, Image);

    _React$Component.apply(this, arguments);
  }

  Image.prototype.render = function render() {
    var _classes;

    var _props = this.props;
    var responsive = _props.responsive;
    var rounded = _props.rounded;
    var circle = _props.circle;
    var thumbnail = _props.thumbnail;
    var className = _props.className;

    var props = _objectWithoutProperties(_props, ['responsive', 'rounded', 'circle', 'thumbnail', 'className']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = (_classes = {}, _classes[_utilsBootstrapUtils.prefix(bsProps, 'responsive')] = responsive, _classes[_utilsBootstrapUtils.prefix(bsProps, 'rounded')] = rounded, _classes[_utilsBootstrapUtils.prefix(bsProps, 'circle')] = circle, _classes[_utilsBootstrapUtils.prefix(bsProps, 'thumbnail')] = thumbnail, _classes);

    return _react2['default'].createElement('img', _extends({}, elementProps, {
      className: _classnames2['default'](className, classes)
    }));
  };

  return Image;
})(_react2['default'].Component);

Image.propTypes = propTypes;
Image.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('img', Image);
module.exports = exports['default'];