'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactPropTypesLibElementType = require('react-prop-types/lib/elementType');

var _reactPropTypesLibElementType2 = _interopRequireDefault(_reactPropTypesLibElementType);

var _ListGroupItem = require('./ListGroupItem');

var _ListGroupItem2 = _interopRequireDefault(_ListGroupItem);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var _utilsValidComponentChildren = require('./utils/ValidComponentChildren');

var _utilsValidComponentChildren2 = _interopRequireDefault(_utilsValidComponentChildren);

var propTypes = {
  /**
   * You can use a custom element type for this component.
   *
   * If not specified, it will be treated as `'li'` if every child is a
   * non-actionable `<ListGroupItem>`, and `'div'` otherwise.
   */
  componentClass: _reactPropTypesLibElementType2['default']
};

function getDefaultComponent(children) {
  if (!children) {
    // FIXME: This is the old behavior. Is this right?
    return 'div';
  }

  if (_utilsValidComponentChildren2['default'].some(children, function (child) {
    return child.type !== _ListGroupItem2['default'] || child.props.href || child.props.onClick;
  })) {
    return 'div';
  }

  return 'ul';
}

var ListGroup = (function (_React$Component) {
  _inherits(ListGroup, _React$Component);

  function ListGroup() {
    _classCallCheck(this, ListGroup);

    _React$Component.apply(this, arguments);
  }

  ListGroup.prototype.render = function render() {
    var _props = this.props;
    var children = _props.children;
    var _props$componentClass = _props.componentClass;
    var Component = _props$componentClass === undefined ? getDefaultComponent(children) : _props$componentClass;
    var className = _props.className;

    var props = _objectWithoutProperties(_props, ['children', 'componentClass', 'className']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = _utilsBootstrapUtils.getClassSet(bsProps);

    var useListItem = Component === 'ul' && _utilsValidComponentChildren2['default'].every(children, function (child) {
      return child.type === _ListGroupItem2['default'];
    });

    return _react2['default'].createElement(
      Component,
      _extends({}, elementProps, {
        className: _classnames2['default'](className, classes)
      }),
      useListItem ? _utilsValidComponentChildren2['default'].map(children, function (child) {
        return _react.cloneElement(child, { listItem: true });
      }) : children
    );
  };

  return ListGroup;
})(_react2['default'].Component);

ListGroup.propTypes = propTypes;

exports['default'] = _utilsBootstrapUtils.bsClass('list-group', ListGroup);
module.exports = exports['default'];