'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _Object$values = require('babel-runtime/core-js/object/values')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Collapse = require('./Collapse');

var _Collapse2 = _interopRequireDefault(_Collapse);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var _utilsStyleConfig = require('./utils/StyleConfig');

// TODO: Use uncontrollable.

var propTypes = {
  collapsible: _react2['default'].PropTypes.bool,
  onSelect: _react2['default'].PropTypes.func,
  header: _react2['default'].PropTypes.node,
  id: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.string, _react2['default'].PropTypes.number]),
  footer: _react2['default'].PropTypes.node,
  defaultExpanded: _react2['default'].PropTypes.bool,
  expanded: _react2['default'].PropTypes.bool,
  eventKey: _react2['default'].PropTypes.any,
  headerRole: _react2['default'].PropTypes.string,
  panelRole: _react2['default'].PropTypes.string,

  // From Collapse.
  onEnter: _react2['default'].PropTypes.func,
  onEntering: _react2['default'].PropTypes.func,
  onEntered: _react2['default'].PropTypes.func,
  onExit: _react2['default'].PropTypes.func,
  onExiting: _react2['default'].PropTypes.func,
  onExited: _react2['default'].PropTypes.func
};

var defaultProps = {
  defaultExpanded: false
};

var Panel = (function (_React$Component) {
  _inherits(Panel, _React$Component);

  function Panel(props, context) {
    _classCallCheck(this, Panel);

    _React$Component.call(this, props, context);

    this.handleClickTitle = this.handleClickTitle.bind(this);

    this.state = {
      expanded: this.props.defaultExpanded
    };
  }

  Panel.prototype.handleClickTitle = function handleClickTitle(e) {
    // FIXME: What the heck? This API is horrible. This needs to go away!
    e.persist();
    e.selected = true;

    if (this.props.onSelect) {
      this.props.onSelect(this.props.eventKey, e);
    } else {
      e.preventDefault();
    }

    if (e.selected) {
      this.setState({ expanded: !this.state.expanded });
    }
  };

  Panel.prototype.shouldRenderFill = function shouldRenderFill(child) {
    return _react2['default'].isValidElement(child) && child.props.fill != null;
  };

  Panel.prototype.renderHeader = function renderHeader(collapsible, header, id, role, expanded, bsProps) {
    var titleClassName = _utilsBootstrapUtils.prefix(bsProps, 'title');

    if (!collapsible) {
      if (!_react2['default'].isValidElement(header)) {
        return header;
      }

      return _react.cloneElement(header, {
        className: _classnames2['default'](header.props.className, titleClassName)
      });
    }

    if (!_react2['default'].isValidElement(header)) {
      return _react2['default'].createElement(
        'h4',
        { role: 'presentation', className: titleClassName },
        this.renderAnchor(header, id, role, expanded)
      );
    }

    return _react.cloneElement(header, {
      className: _classnames2['default'](header.props.className, titleClassName),
      children: this.renderAnchor(header.props.children, role)
    });
  };

  Panel.prototype.renderAnchor = function renderAnchor(header, id, role, expanded) {
    return _react2['default'].createElement(
      'a',
      {
        role: role,
        href: id && '#' + id,
        onClick: this.handleClickTitle,
        'aria-controls': id,
        'aria-expanded': expanded,
        'aria-selected': expanded
      },
      header
    );
  };

  Panel.prototype.renderCollapsibleBody = function renderCollapsibleBody(id, expanded, role, children, bsProps, animationHooks) {
    return _react2['default'].createElement(
      _Collapse2['default'],
      _extends({ 'in': expanded }, animationHooks),
      _react2['default'].createElement(
        'div',
        {
          id: id,
          role: role,
          className: _utilsBootstrapUtils.prefix(bsProps, 'collapse'),
          'aria-hidden': !expanded
        },
        this.renderBody(children, bsProps)
      )
    );
  };

  Panel.prototype.renderBody = function renderBody(rawChildren, bsProps) {
    var children = [];
    var bodyChildren = [];

    var bodyClassName = _utilsBootstrapUtils.prefix(bsProps, 'body');

    function maybeAddBody() {
      if (!bodyChildren.length) {
        return;
      }

      // Derive the key from the index here, since we need to make one up.
      children.push(_react2['default'].createElement(
        'div',
        { key: children.length, className: bodyClassName },
        bodyChildren
      ));

      bodyChildren = [];
    }

    // Convert to array so we can re-use keys.
    _react2['default'].Children.toArray(rawChildren).forEach(function (child) {
      if (_react2['default'].isValidElement(child) && child.props.fill) {
        maybeAddBody();

        // Remove the child's unknown `fill` prop.
        children.push(_react.cloneElement(child, { fill: undefined }));

        return;
      }

      bodyChildren.push(child);
    });

    maybeAddBody();

    return children;
  };

  Panel.prototype.render = function render() {
    var _props = this.props;
    var collapsible = _props.collapsible;
    var header = _props.header;
    var id = _props.id;
    var footer = _props.footer;
    var propsExpanded = _props.expanded;
    var headerRole = _props.headerRole;
    var panelRole = _props.panelRole;
    var className = _props.className;
    var children = _props.children;
    var onEnter = _props.onEnter;
    var onEntering = _props.onEntering;
    var onEntered = _props.onEntered;
    var onExit = _props.onExit;
    var onExiting = _props.onExiting;
    var onExited = _props.onExited;

    var props = _objectWithoutProperties(_props, ['collapsible', 'header', 'id', 'footer', 'expanded', 'headerRole', 'panelRole', 'className', 'children', 'onEnter', 'onEntering', 'onEntered', 'onExit', 'onExiting', 'onExited']);

    var _splitBsPropsAndOmit = _utilsBootstrapUtils.splitBsPropsAndOmit(props, ['defaultExpanded', 'eventKey', 'onSelect']);

    var bsProps = _splitBsPropsAndOmit[0];
    var elementProps = _splitBsPropsAndOmit[1];

    var expanded = propsExpanded != null ? propsExpanded : this.state.expanded;

    var classes = _utilsBootstrapUtils.getClassSet(bsProps);

    return _react2['default'].createElement(
      'div',
      _extends({}, elementProps, {
        className: _classnames2['default'](className, classes),
        id: collapsible ? null : id
      }),
      header && _react2['default'].createElement(
        'div',
        { className: _utilsBootstrapUtils.prefix(bsProps, 'heading') },
        this.renderHeader(collapsible, header, id, headerRole, expanded, bsProps)
      ),
      collapsible ? this.renderCollapsibleBody(id, expanded, panelRole, children, bsProps, { onEnter: onEnter, onEntering: onEntering, onEntered: onEntered, onExit: onExit, onExiting: onExiting, onExited: onExited }) : this.renderBody(children, bsProps),
      footer && _react2['default'].createElement(
        'div',
        { className: _utilsBootstrapUtils.prefix(bsProps, 'footer') },
        footer
      )
    );
  };

  return Panel;
})(_react2['default'].Component);

Panel.propTypes = propTypes;
Panel.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('panel', _utilsBootstrapUtils.bsStyles([].concat(_Object$values(_utilsStyleConfig.State), [_utilsStyleConfig.Style.DEFAULT, _utilsStyleConfig.Style.PRIMARY]), Panel));
module.exports = exports['default'];