'use strict';

var _extends = require('babel-runtime/helpers/extends')['default'];

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Button = require('./Button');

var _Button2 = _interopRequireDefault(_Button);

var _Dropdown = require('./Dropdown');

var _Dropdown2 = _interopRequireDefault(_Dropdown);

var _SplitToggle = require('./SplitToggle');

var _SplitToggle2 = _interopRequireDefault(_SplitToggle);

var _utilsSplitComponentProps = require('./utils/splitComponentProps');

var _utilsSplitComponentProps2 = _interopRequireDefault(_utilsSplitComponentProps);

var propTypes = _extends({}, _Dropdown2['default'].propTypes, {

  // Toggle props.
  bsStyle: _react2['default'].PropTypes.string,
  bsSize: _react2['default'].PropTypes.string,
  href: _react2['default'].PropTypes.string,
  onClick: _react2['default'].PropTypes.func,
  /**
   * The content of the split button.
   */
  title: _react2['default'].PropTypes.node.isRequired,
  /**
   * Accessible label for the toggle; the value of `title` if not specified.
   */
  toggleLabel: _react2['default'].PropTypes.string,

  // Override generated docs from <Dropdown>.
  /**
   * @private
   */
  children: _react2['default'].PropTypes.node
});

var SplitButton = (function (_React$Component) {
  _inherits(SplitButton, _React$Component);

  function SplitButton() {
    _classCallCheck(this, SplitButton);

    _React$Component.apply(this, arguments);
  }

  SplitButton.prototype.render = function render() {
    var _props = this.props;
    var bsSize = _props.bsSize;
    var bsStyle = _props.bsStyle;
    var title = _props.title;
    var toggleLabel = _props.toggleLabel;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['bsSize', 'bsStyle', 'title', 'toggleLabel', 'children']);

    var _splitComponentProps = _utilsSplitComponentProps2['default'](props, _Dropdown2['default'].ControlledComponent);

    var dropdownProps = _splitComponentProps[0];
    var buttonProps = _splitComponentProps[1];

    return _react2['default'].createElement(
      _Dropdown2['default'],
      _extends({}, dropdownProps, {
        bsSize: bsSize,
        bsStyle: bsStyle
      }),
      _react2['default'].createElement(
        _Button2['default'],
        _extends({}, buttonProps, {
          disabled: props.disabled,
          bsSize: bsSize,
          bsStyle: bsStyle
        }),
        title
      ),
      _react2['default'].createElement(_SplitToggle2['default'], {
        'aria-label': toggleLabel || title,
        bsSize: bsSize,
        bsStyle: bsStyle
      }),
      _react2['default'].createElement(
        _Dropdown2['default'].Menu,
        null,
        children
      )
    );
  };

  return SplitButton;
})(_react2['default'].Component);

SplitButton.propTypes = propTypes;

SplitButton.Toggle = _SplitToggle2['default'];

exports['default'] = SplitButton;
module.exports = exports['default'];