'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactPropTypesLibElementType = require('react-prop-types/lib/elementType');

var _reactPropTypesLibElementType2 = _interopRequireDefault(_reactPropTypesLibElementType);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var _utilsCapitalize = require('./utils/capitalize');

var _utilsCapitalize2 = _interopRequireDefault(_utilsCapitalize);

var _utilsStyleConfig = require('./utils/StyleConfig');

var propTypes = {
  componentClass: _reactPropTypesLibElementType2['default'],

  /**
   * Apply clearfix
   *
   * on Extra small devices Phones
   *
   * adds class `visible-xs-block`
   */
  visibleXsBlock: _react2['default'].PropTypes.bool,
  /**
   * Apply clearfix
   *
   * on Small devices Tablets
   *
   * adds class `visible-sm-block`
   */
  visibleSmBlock: _react2['default'].PropTypes.bool,
  /**
   * Apply clearfix
   *
   * on Medium devices Desktops
   *
   * adds class `visible-md-block`
   */
  visibleMdBlock: _react2['default'].PropTypes.bool,
  /**
   * Apply clearfix
   *
   * on Large devices Desktops
   *
   * adds class `visible-lg-block`
   */
  visibleLgBlock: _react2['default'].PropTypes.bool
};

var defaultProps = {
  componentClass: 'div'
};

var Clearfix = (function (_React$Component) {
  _inherits(Clearfix, _React$Component);

  function Clearfix() {
    _classCallCheck(this, Clearfix);

    _React$Component.apply(this, arguments);
  }

  Clearfix.prototype.render = function render() {
    var _props = this.props;
    var Component = _props.componentClass;
    var className = _props.className;

    var props = _objectWithoutProperties(_props, ['componentClass', 'className']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = _utilsBootstrapUtils.getClassSet(bsProps);

    _utilsStyleConfig.DEVICE_SIZES.forEach(function (size) {
      var propName = 'visible' + _utilsCapitalize2['default'](size) + 'Block';
      if (elementProps[propName]) {
        classes['visible-' + size + '-block'] = true;
      }

      delete elementProps[propName];
    });

    return _react2['default'].createElement(Component, _extends({}, elementProps, {
      className: _classnames2['default'](className, classes)
    }));
  };

  return Clearfix;
})(_react2['default'].Component);

Clearfix.propTypes = propTypes;
Clearfix.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('clearfix', Clearfix);
module.exports = exports['default'];