'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _SafeAnchor = require('./SafeAnchor');

var _SafeAnchor2 = _interopRequireDefault(_SafeAnchor);

var _utilsCreateChainedFunction = require('./utils/createChainedFunction');

var _utilsCreateChainedFunction2 = _interopRequireDefault(_utilsCreateChainedFunction);

var propTypes = {
  disabled: _react2['default'].PropTypes.bool,
  previous: _react2['default'].PropTypes.bool,
  next: _react2['default'].PropTypes.bool,
  onClick: _react2['default'].PropTypes.func,
  onSelect: _react2['default'].PropTypes.func,
  eventKey: _react2['default'].PropTypes.any
};

var defaultProps = {
  disabled: false,
  previous: false,
  next: false
};

var PagerItem = (function (_React$Component) {
  _inherits(PagerItem, _React$Component);

  function PagerItem(props, context) {
    _classCallCheck(this, PagerItem);

    _React$Component.call(this, props, context);

    this.handleSelect = this.handleSelect.bind(this);
  }

  PagerItem.prototype.handleSelect = function handleSelect(e) {
    var _props = this.props;
    var disabled = _props.disabled;
    var onSelect = _props.onSelect;
    var eventKey = _props.eventKey;

    if (onSelect || disabled) {
      e.preventDefault();
    }

    if (disabled) {
      return;
    }

    if (onSelect) {
      onSelect(eventKey, e);
    }
  };

  PagerItem.prototype.render = function render() {
    var _props2 = this.props;
    var disabled = _props2.disabled;
    var previous = _props2.previous;
    var next = _props2.next;
    var onClick = _props2.onClick;
    var className = _props2.className;
    var style = _props2.style;

    var props = _objectWithoutProperties(_props2, ['disabled', 'previous', 'next', 'onClick', 'className', 'style']);

    delete props.onSelect;
    delete props.eventKey;

    return _react2['default'].createElement(
      'li',
      {
        className: _classnames2['default'](className, { disabled: disabled, previous: previous, next: next }),
        style: style
      },
      _react2['default'].createElement(_SafeAnchor2['default'], _extends({}, props, {
        disabled: disabled,
        onClick: _utilsCreateChainedFunction2['default'](onClick, this.handleSelect)
      }))
    );
  };

  return PagerItem;
})(_react2['default'].Component);

PagerItem.propTypes = propTypes;
PagerItem.defaultProps = defaultProps;

exports['default'] = PagerItem;
module.exports = exports['default'];