'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _Object$assign = require('babel-runtime/core-js/object/assign')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var _utilsCreateChainedFunction = require('./utils/createChainedFunction');

var _utilsCreateChainedFunction2 = _interopRequireDefault(_utilsCreateChainedFunction);

var _utilsValidComponentChildren = require('./utils/ValidComponentChildren');

var _utilsValidComponentChildren2 = _interopRequireDefault(_utilsValidComponentChildren);

var propTypes = {
  accordion: _react2['default'].PropTypes.bool,
  activeKey: _react2['default'].PropTypes.any,
  defaultActiveKey: _react2['default'].PropTypes.any,
  onSelect: _react2['default'].PropTypes.func,
  role: _react2['default'].PropTypes.string
};

var defaultProps = {
  accordion: false
};

// TODO: Use uncontrollable.

var PanelGroup = (function (_React$Component) {
  _inherits(PanelGroup, _React$Component);

  function PanelGroup(props, context) {
    _classCallCheck(this, PanelGroup);

    _React$Component.call(this, props, context);

    this.handleSelect = this.handleSelect.bind(this);

    this.state = {
      activeKey: props.defaultActiveKey
    };
  }

  PanelGroup.prototype.handleSelect = function handleSelect(key, e) {
    e.preventDefault();

    if (this.props.onSelect) {
      this.props.onSelect(key, e);
    }

    if (this.state.activeKey === key) {
      key = null;
    }

    this.setState({ activeKey: key });
  };

  PanelGroup.prototype.render = function render() {
    var _this = this;

    var _props = this.props;
    var accordion = _props.accordion;
    var propsActiveKey = _props.activeKey;
    var className = _props.className;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['accordion', 'activeKey', 'className', 'children']);

    var _splitBsPropsAndOmit = _utilsBootstrapUtils.splitBsPropsAndOmit(props, ['defaultActiveKey', 'onSelect']);

    var bsProps = _splitBsPropsAndOmit[0];
    var elementProps = _splitBsPropsAndOmit[1];

    var activeKey = undefined;
    if (accordion) {
      activeKey = propsActiveKey != null ? propsActiveKey : this.state.activeKey;
      elementProps.role = elementProps.role || 'tablist';
    }

    var classes = _utilsBootstrapUtils.getClassSet(bsProps);

    return _react2['default'].createElement(
      'div',
      _extends({}, elementProps, {
        className: _classnames2['default'](className, classes)
      }),
      _utilsValidComponentChildren2['default'].map(children, function (child) {
        var childProps = {
          bsStyle: child.props.bsStyle || bsProps.bsStyle
        };

        if (accordion) {
          _Object$assign(childProps, {
            headerRole: 'tab',
            panelRole: 'tabpanel',
            collapsible: true,
            expanded: child.props.eventKey === activeKey,
            onSelect: _utilsCreateChainedFunction2['default'](_this.handleSelect, child.props.onSelect)
          });
        }

        return _react.cloneElement(child, childProps);
      })
    );
  };

  return PanelGroup;
})(_react2['default'].Component);

PanelGroup.propTypes = propTypes;
PanelGroup.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('panel-group', PanelGroup);
module.exports = exports['default'];