'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _SafeAnchor = require('./SafeAnchor');

var _SafeAnchor2 = _interopRequireDefault(_SafeAnchor);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var propTypes = {
  src: _react2['default'].PropTypes.string,
  alt: _react2['default'].PropTypes.string,
  href: _react2['default'].PropTypes.string
};

var Thumbnail = (function (_React$Component) {
  _inherits(Thumbnail, _React$Component);

  function Thumbnail() {
    _classCallCheck(this, Thumbnail);

    _React$Component.apply(this, arguments);
  }

  Thumbnail.prototype.render = function render() {
    var _props = this.props;
    var src = _props.src;
    var alt = _props.alt;
    var className = _props.className;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['src', 'alt', 'className', 'children']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var Component = elementProps.href ? _SafeAnchor2['default'] : 'div';
    var classes = _utilsBootstrapUtils.getClassSet(bsProps);

    return _react2['default'].createElement(
      Component,
      _extends({}, elementProps, {
        className: _classnames2['default'](className, classes)
      }),
      _react2['default'].createElement('img', { src: src, alt: alt }),
      children && _react2['default'].createElement(
        'div',
        { className: 'caption' },
        children
      )
    );
  };

  return Thumbnail;
})(_react2['default'].Component);

Thumbnail.propTypes = propTypes;

exports['default'] = _utilsBootstrapUtils.bsClass('thumbnail', Thumbnail);
module.exports = exports['default'];