'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

// TODO: `pullRight` doesn't belong here. There's no special handling here.

var propTypes = {
  pullRight: _react2['default'].PropTypes.bool
};

var defaultProps = {
  pullRight: false
};

var Badge = (function (_React$Component) {
  _inherits(Badge, _React$Component);

  function Badge() {
    _classCallCheck(this, Badge);

    _React$Component.apply(this, arguments);
  }

  Badge.prototype.hasContent = function hasContent(children) {
    var result = false;

    _react2['default'].Children.forEach(children, function (child) {
      if (result) {
        return;
      }

      if (child || child === 0) {
        result = true;
      }
    });

    return result;
  };

  Badge.prototype.render = function render() {
    var _props = this.props;
    var pullRight = _props.pullRight;
    var className = _props.className;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['pullRight', 'className', 'children']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = _extends({}, _utilsBootstrapUtils.getClassSet(bsProps), {
      'pull-right': pullRight,

      // Hack for collapsing on IE8.
      hidden: !this.hasContent(children)
    });

    return _react2['default'].createElement(
      'span',
      _extends({}, elementProps, {
        className: _classnames2['default'](className, classes)
      }),
      children
    );
  };

  return Badge;
})(_react2['default'].Component);

Badge.propTypes = propTypes;
Badge.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('badge', Badge);
module.exports = exports['default'];