'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _Object$values = require('babel-runtime/core-js/object/values')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactPropTypesLibElementType = require('react-prop-types/lib/elementType');

var _reactPropTypesLibElementType2 = _interopRequireDefault(_reactPropTypesLibElementType);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var _utilsStyleConfig = require('./utils/StyleConfig');

var _SafeAnchor = require('./SafeAnchor');

var _SafeAnchor2 = _interopRequireDefault(_SafeAnchor);

var propTypes = {
  active: _react2['default'].PropTypes.bool,
  disabled: _react2['default'].PropTypes.bool,
  block: _react2['default'].PropTypes.bool,
  onClick: _react2['default'].PropTypes.func,
  componentClass: _reactPropTypesLibElementType2['default'],
  href: _react2['default'].PropTypes.string,
  /**
   * Defines HTML button type attribute
   * @defaultValue 'button'
   */
  type: _react2['default'].PropTypes.oneOf(['button', 'reset', 'submit'])
};

var defaultProps = {
  active: false,
  block: false,
  disabled: false
};

var Button = (function (_React$Component) {
  _inherits(Button, _React$Component);

  function Button() {
    _classCallCheck(this, Button);

    _React$Component.apply(this, arguments);
  }

  Button.prototype.renderAnchor = function renderAnchor(elementProps, className) {
    return _react2['default'].createElement(_SafeAnchor2['default'], _extends({}, elementProps, {
      className: _classnames2['default'](className, elementProps.disabled && 'disabled')
    }));
  };

  Button.prototype.renderButton = function renderButton(_ref, className) {
    var componentClass = _ref.componentClass;

    var elementProps = _objectWithoutProperties(_ref, ['componentClass']);

    var Component = componentClass || 'button';

    return _react2['default'].createElement(Component, _extends({}, elementProps, {
      type: elementProps.type || 'button',
      className: className
    }));
  };

  Button.prototype.render = function render() {
    var _extends2;

    var _props = this.props;
    var active = _props.active;
    var block = _props.block;
    var className = _props.className;

    var props = _objectWithoutProperties(_props, ['active', 'block', 'className']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = _extends({}, _utilsBootstrapUtils.getClassSet(bsProps), (_extends2 = {
      active: active
    }, _extends2[_utilsBootstrapUtils.prefix(bsProps, 'block')] = block, _extends2));
    var fullClassName = _classnames2['default'](className, classes);

    if (elementProps.href) {
      return this.renderAnchor(elementProps, fullClassName);
    }

    return this.renderButton(elementProps, fullClassName);
  };

  return Button;
})(_react2['default'].Component);

Button.propTypes = propTypes;
Button.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('btn', _utilsBootstrapUtils.bsSizes([_utilsStyleConfig.Size.LARGE, _utilsStyleConfig.Size.SMALL, _utilsStyleConfig.Size.XSMALL], _utilsBootstrapUtils.bsStyles([].concat(_Object$values(_utilsStyleConfig.State), [_utilsStyleConfig.Style.DEFAULT, _utilsStyleConfig.Style.PRIMARY, _utilsStyleConfig.Style.LINK]), _utilsStyleConfig.Style.DEFAULT, Button)));
module.exports = exports['default'];