'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactPropTypesLibAll = require('react-prop-types/lib/all');

var _reactPropTypesLibAll2 = _interopRequireDefault(_reactPropTypesLibAll);

var _Button = require('./Button');

var _Button2 = _interopRequireDefault(_Button);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var propTypes = {
  vertical: _react2['default'].PropTypes.bool,
  justified: _react2['default'].PropTypes.bool,

  /**
   * Display block buttons; only useful when used with the "vertical" prop.
   * @type {bool}
   */
  block: _reactPropTypesLibAll2['default'](_react2['default'].PropTypes.bool, function (_ref) {
    var block = _ref.block;
    var vertical = _ref.vertical;
    return block && !vertical ? new Error('`block` requires `vertical` to be set to have any effect') : null;
  })
};

var defaultProps = {
  block: false,
  justified: false,
  vertical: false
};

var ButtonGroup = (function (_React$Component) {
  _inherits(ButtonGroup, _React$Component);

  function ButtonGroup() {
    _classCallCheck(this, ButtonGroup);

    _React$Component.apply(this, arguments);
  }

  ButtonGroup.prototype.render = function render() {
    var _extends2;

    var _props = this.props;
    var block = _props.block;
    var justified = _props.justified;
    var vertical = _props.vertical;
    var className = _props.className;

    var props = _objectWithoutProperties(_props, ['block', 'justified', 'vertical', 'className']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = _extends({}, _utilsBootstrapUtils.getClassSet(bsProps), (_extends2 = {}, _extends2[_utilsBootstrapUtils.prefix(bsProps)] = !vertical, _extends2[_utilsBootstrapUtils.prefix(bsProps, 'vertical')] = vertical, _extends2[_utilsBootstrapUtils.prefix(bsProps, 'justified')] = justified, _extends2[_utilsBootstrapUtils.prefix(_Button2['default'].defaultProps, 'block')] = block, _extends2));

    return _react2['default'].createElement('div', _extends({}, elementProps, {
      className: _classnames2['default'](className, classes)
    }));
  };

  return ButtonGroup;
})(_react2['default'].Component);

ButtonGroup.propTypes = propTypes;
ButtonGroup.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('btn-group', ButtonGroup);
module.exports = exports['default'];

// this is annoying, since the class is `btn-block` not `btn-group-block`