'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _Button = require('./Button');

var _Button2 = _interopRequireDefault(_Button);

var _SafeAnchor = require('./SafeAnchor');

var _SafeAnchor2 = _interopRequireDefault(_SafeAnchor);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var propTypes = {
  noCaret: _react2['default'].PropTypes.bool,
  open: _react2['default'].PropTypes.bool,
  title: _react2['default'].PropTypes.string,
  useAnchor: _react2['default'].PropTypes.bool
};

var defaultProps = {
  open: false,
  useAnchor: false,
  bsRole: 'toggle'
};

var DropdownToggle = (function (_React$Component) {
  _inherits(DropdownToggle, _React$Component);

  function DropdownToggle() {
    _classCallCheck(this, DropdownToggle);

    _React$Component.apply(this, arguments);
  }

  DropdownToggle.prototype.render = function render() {
    var _props = this.props;
    var noCaret = _props.noCaret;
    var open = _props.open;
    var useAnchor = _props.useAnchor;
    var bsClass = _props.bsClass;
    var className = _props.className;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['noCaret', 'open', 'useAnchor', 'bsClass', 'className', 'children']);

    delete props.bsRole;

    var Component = useAnchor ? _SafeAnchor2['default'] : _Button2['default'];
    var useCaret = !noCaret;

    // This intentionally forwards bsSize and bsStyle (if set) to the
    // underlying component, to allow it to render size and style variants.

    // FIXME: Should this really fall back to `title` as children?

    return _react2['default'].createElement(
      Component,
      _extends({}, props, {
        role: 'button',
        className: _classnames2['default'](className, bsClass),
        'aria-haspopup': true,
        'aria-expanded': open
      }),
      children || props.title,
      useCaret && ' ',
      useCaret && _react2['default'].createElement('span', { className: 'caret' })
    );
  };

  return DropdownToggle;
})(_react2['default'].Component);

DropdownToggle.propTypes = propTypes;
DropdownToggle.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('dropdown-toggle', DropdownToggle);
module.exports = exports['default'];