'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _Object$values = require('babel-runtime/core-js/object/values')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var _utilsStyleConfig = require('./utils/StyleConfig');

var propTypes = {
  active: _react2['default'].PropTypes.any,
  disabled: _react2['default'].PropTypes.any,
  header: _react2['default'].PropTypes.node,
  listItem: _react2['default'].PropTypes.bool,
  onClick: _react2['default'].PropTypes.func,
  href: _react2['default'].PropTypes.string,
  type: _react2['default'].PropTypes.string
};

var defaultProps = {
  listItem: false
};

var ListGroupItem = (function (_React$Component) {
  _inherits(ListGroupItem, _React$Component);

  function ListGroupItem() {
    _classCallCheck(this, ListGroupItem);

    _React$Component.apply(this, arguments);
  }

  ListGroupItem.prototype.renderHeader = function renderHeader(header, headingClassName) {
    if (_react2['default'].isValidElement(header)) {
      return _react.cloneElement(header, {
        className: _classnames2['default'](header.props.className, headingClassName)
      });
    }

    return _react2['default'].createElement(
      'h4',
      { className: headingClassName },
      header
    );
  };

  ListGroupItem.prototype.render = function render() {
    var _props = this.props;
    var active = _props.active;
    var disabled = _props.disabled;
    var className = _props.className;
    var header = _props.header;
    var listItem = _props.listItem;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['active', 'disabled', 'className', 'header', 'listItem', 'children']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = _extends({}, _utilsBootstrapUtils.getClassSet(bsProps), {
      active: active,
      disabled: disabled
    });

    var Component = undefined;

    if (elementProps.href) {
      Component = 'a';
    } else if (elementProps.onClick) {
      Component = 'button';
      elementProps.type = elementProps.type || 'button';
    } else if (listItem) {
      Component = 'li';
    } else {
      Component = 'span';
    }

    elementProps.className = _classnames2['default'](className, classes);

    // TODO: Deprecate `header` prop.
    if (header) {
      return _react2['default'].createElement(
        Component,
        elementProps,
        this.renderHeader(header, _utilsBootstrapUtils.prefix(bsProps, 'heading')),
        _react2['default'].createElement(
          'p',
          { className: _utilsBootstrapUtils.prefix(bsProps, 'text') },
          children
        )
      );
    }

    return _react2['default'].createElement(
      Component,
      elementProps,
      children
    );
  };

  return ListGroupItem;
})(_react2['default'].Component);

ListGroupItem.propTypes = propTypes;
ListGroupItem.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('list-group-item', _utilsBootstrapUtils.bsStyles(_Object$values(_utilsStyleConfig.State), ListGroupItem));
module.exports = exports['default'];