'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Media = require('./Media');

var _Media2 = _interopRequireDefault(_Media);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var propTypes = {
  /**
   * Align the media to the top, middle, or bottom of the media object.
   */
  align: _react2['default'].PropTypes.oneOf(['top', 'middle', 'bottom'])
};

var MediaLeft = (function (_React$Component) {
  _inherits(MediaLeft, _React$Component);

  function MediaLeft() {
    _classCallCheck(this, MediaLeft);

    _React$Component.apply(this, arguments);
  }

  MediaLeft.prototype.render = function render() {
    var _props = this.props;
    var align = _props.align;
    var className = _props.className;

    var props = _objectWithoutProperties(_props, ['align', 'className']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = _utilsBootstrapUtils.getClassSet(bsProps);

    if (align) {
      // The class is e.g. `media-top`, not `media-left-top`.
      classes[_utilsBootstrapUtils.prefix(_Media2['default'].defaultProps, align)] = true;
    }

    return _react2['default'].createElement('div', _extends({}, elementProps, {
      className: _classnames2['default'](className, classes)
    }));
  };

  return MediaLeft;
})(_react2['default'].Component);

MediaLeft.propTypes = propTypes;

exports['default'] = _utilsBootstrapUtils.bsClass('media-left', MediaLeft);
module.exports = exports['default'];