'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Collapse = require('./Collapse');

var _Collapse2 = _interopRequireDefault(_Collapse);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var contextTypes = {
  $bs_navbar: _react.PropTypes.shape({
    bsClass: _react.PropTypes.string,
    expanded: _react.PropTypes.bool
  })
};

var NavbarCollapse = (function (_React$Component) {
  _inherits(NavbarCollapse, _React$Component);

  function NavbarCollapse() {
    _classCallCheck(this, NavbarCollapse);

    _React$Component.apply(this, arguments);
  }

  NavbarCollapse.prototype.render = function render() {
    var _props = this.props;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['children']);

    var navbarProps = this.context.$bs_navbar || { bsClass: 'navbar' };

    var bsClassName = _utilsBootstrapUtils.prefix(navbarProps, 'collapse');

    return _react2['default'].createElement(
      _Collapse2['default'],
      _extends({ 'in': navbarProps.expanded }, props),
      _react2['default'].createElement(
        'div',
        { className: bsClassName },
        children
      )
    );
  };

  return NavbarCollapse;
})(_react2['default'].Component);

NavbarCollapse.contextTypes = contextTypes;

exports['default'] = NavbarCollapse;
module.exports = exports['default'];