'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _PagerItem = require('./PagerItem');

var _PagerItem2 = _interopRequireDefault(_PagerItem);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var _utilsCreateChainedFunction = require('./utils/createChainedFunction');

var _utilsCreateChainedFunction2 = _interopRequireDefault(_utilsCreateChainedFunction);

var _utilsValidComponentChildren = require('./utils/ValidComponentChildren');

var _utilsValidComponentChildren2 = _interopRequireDefault(_utilsValidComponentChildren);

var propTypes = {
  onSelect: _react2['default'].PropTypes.func
};

var Pager = (function (_React$Component) {
  _inherits(Pager, _React$Component);

  function Pager() {
    _classCallCheck(this, Pager);

    _React$Component.apply(this, arguments);
  }

  Pager.prototype.render = function render() {
    var _props = this.props;
    var onSelect = _props.onSelect;
    var className = _props.className;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['onSelect', 'className', 'children']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = _utilsBootstrapUtils.getClassSet(bsProps);

    return _react2['default'].createElement(
      'ul',
      _extends({}, elementProps, {
        className: _classnames2['default'](className, classes)
      }),
      _utilsValidComponentChildren2['default'].map(children, function (child) {
        return _react.cloneElement(child, {
          onSelect: _utilsCreateChainedFunction2['default'](child.props.onSelect, onSelect)
        });
      })
    );
  };

  return Pager;
})(_react2['default'].Component);

Pager.propTypes = propTypes;

Pager.Item = _PagerItem2['default'];

exports['default'] = _utilsBootstrapUtils.bsClass('pager', Pager);
module.exports = exports['default'];