'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactPropTypesLibElementType = require('react-prop-types/lib/elementType');

var _reactPropTypesLibElementType2 = _interopRequireDefault(_reactPropTypesLibElementType);

var _PaginationButton = require('./PaginationButton');

var _PaginationButton2 = _interopRequireDefault(_PaginationButton);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var propTypes = {
  activePage: _react2['default'].PropTypes.number,
  items: _react2['default'].PropTypes.number,
  maxButtons: _react2['default'].PropTypes.number,

  /**
   * When `true`, will display the first and the last button page
   */
  boundaryLinks: _react2['default'].PropTypes.bool,

  /**
   * When `true`, will display the default node value ('&hellip;').
   * Otherwise, will display provided node (when specified).
   */
  ellipsis: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.bool, _react2['default'].PropTypes.node]),

  /**
   * When `true`, will display the default node value ('&laquo;').
   * Otherwise, will display provided node (when specified).
   */
  first: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.bool, _react2['default'].PropTypes.node]),

  /**
   * When `true`, will display the default node value ('&raquo;').
   * Otherwise, will display provided node (when specified).
   */
  last: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.bool, _react2['default'].PropTypes.node]),

  /**
   * When `true`, will display the default node value ('&lsaquo;').
   * Otherwise, will display provided node (when specified).
   */
  prev: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.bool, _react2['default'].PropTypes.node]),

  /**
   * When `true`, will display the default node value ('&rsaquo;').
   * Otherwise, will display provided node (when specified).
   */
  next: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.bool, _react2['default'].PropTypes.node]),

  onSelect: _react2['default'].PropTypes.func,

  /**
   * You can use a custom element for the buttons
   */
  buttonComponentClass: _reactPropTypesLibElementType2['default']
};

var defaultProps = {
  activePage: 1,
  items: 1,
  maxButtons: 0,
  first: false,
  last: false,
  prev: false,
  next: false,
  ellipsis: true,
  boundaryLinks: false
};

var Pagination = (function (_React$Component) {
  _inherits(Pagination, _React$Component);

  function Pagination() {
    _classCallCheck(this, Pagination);

    _React$Component.apply(this, arguments);
  }

  Pagination.prototype.renderPageButtons = function renderPageButtons(activePage, items, maxButtons, boundaryLinks, ellipsis, buttonProps) {
    var pageButtons = [];

    var startPage = undefined;
    var endPage = undefined;
    var hasHiddenPagesAfter = undefined;

    if (maxButtons) {
      var hiddenPagesBefore = activePage - parseInt(maxButtons / 2, 10);
      startPage = hiddenPagesBefore > 1 ? hiddenPagesBefore : 1;
      hasHiddenPagesAfter = startPage + maxButtons <= items;

      if (!hasHiddenPagesAfter) {
        endPage = items;
        startPage = items - maxButtons + 1;
        if (startPage < 1) {
          startPage = 1;
        }
      } else {
        endPage = startPage + maxButtons - 1;
      }
    } else {
      startPage = 1;
      endPage = items;
    }

    for (var pagenumber = startPage; pagenumber <= endPage; pagenumber++) {
      pageButtons.push(_react2['default'].createElement(
        _PaginationButton2['default'],
        _extends({}, buttonProps, {
          key: pagenumber,
          eventKey: pagenumber,
          active: pagenumber === activePage
        }),
        pagenumber
      ));
    }

    if (boundaryLinks && ellipsis && startPage !== 1) {
      pageButtons.unshift(_react2['default'].createElement(
        _PaginationButton2['default'],
        {
          key: 'ellipsisFirst',
          disabled: true,
          componentClass: buttonProps.componentClass
        },
        _react2['default'].createElement(
          'span',
          { 'aria-label': 'More' },
          ellipsis === true ? '…' : ellipsis
        )
      ));

      pageButtons.unshift(_react2['default'].createElement(
        _PaginationButton2['default'],
        _extends({}, buttonProps, {
          key: 1,
          eventKey: 1,
          active: false
        }),
        '1'
      ));
    }

    if (maxButtons && hasHiddenPagesAfter && ellipsis) {
      pageButtons.push(_react2['default'].createElement(
        _PaginationButton2['default'],
        {
          key: 'ellipsis',
          disabled: true,
          componentClass: buttonProps.componentClass
        },
        _react2['default'].createElement(
          'span',
          { 'aria-label': 'More' },
          ellipsis === true ? '…' : ellipsis
        )
      ));

      if (boundaryLinks && endPage !== items) {
        pageButtons.push(_react2['default'].createElement(
          _PaginationButton2['default'],
          _extends({}, buttonProps, {
            key: items,
            eventKey: items,
            active: false
          }),
          items
        ));
      }
    }

    return pageButtons;
  };

  Pagination.prototype.render = function render() {
    var _props = this.props;
    var activePage = _props.activePage;
    var items = _props.items;
    var maxButtons = _props.maxButtons;
    var boundaryLinks = _props.boundaryLinks;
    var ellipsis = _props.ellipsis;
    var first = _props.first;
    var last = _props.last;
    var prev = _props.prev;
    var next = _props.next;
    var onSelect = _props.onSelect;
    var buttonComponentClass = _props.buttonComponentClass;
    var className = _props.className;

    var props = _objectWithoutProperties(_props, ['activePage', 'items', 'maxButtons', 'boundaryLinks', 'ellipsis', 'first', 'last', 'prev', 'next', 'onSelect', 'buttonComponentClass', 'className']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = _utilsBootstrapUtils.getClassSet(bsProps);

    var buttonProps = {
      onSelect: onSelect,
      componentClass: buttonComponentClass
    };

    return _react2['default'].createElement(
      'ul',
      _extends({}, elementProps, {
        className: _classnames2['default'](className, classes)
      }),
      first && _react2['default'].createElement(
        _PaginationButton2['default'],
        _extends({}, buttonProps, {
          eventKey: 1,
          disabled: activePage === 1
        }),
        _react2['default'].createElement(
          'span',
          { 'aria-label': 'First' },
          first === true ? '«' : first
        )
      ),
      prev && _react2['default'].createElement(
        _PaginationButton2['default'],
        _extends({}, buttonProps, {
          eventKey: activePage - 1,
          disabled: activePage === 1
        }),
        _react2['default'].createElement(
          'span',
          { 'aria-label': 'Previous' },
          prev === true ? '‹' : prev
        )
      ),
      this.renderPageButtons(activePage, items, maxButtons, boundaryLinks, ellipsis, buttonProps),
      next && _react2['default'].createElement(
        _PaginationButton2['default'],
        _extends({}, buttonProps, {
          eventKey: activePage + 1,
          disabled: activePage >= items
        }),
        _react2['default'].createElement(
          'span',
          { 'aria-label': 'Next' },
          next === true ? '›' : next
        )
      ),
      last && _react2['default'].createElement(
        _PaginationButton2['default'],
        _extends({}, buttonProps, {
          eventKey: items,
          disabled: activePage >= items
        }),
        _react2['default'].createElement(
          'span',
          { 'aria-label': 'Last' },
          last === true ? '»' : last
        )
      )
    );
  };

  return Pagination;
})(_react2['default'].Component);

Pagination.propTypes = propTypes;
Pagination.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('pagination', Pagination);
module.exports = exports['default'];