'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _Object$values = require('babel-runtime/core-js/object/values')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var _utilsStyleConfig = require('./utils/StyleConfig');

var _utilsValidComponentChildren = require('./utils/ValidComponentChildren');

var _utilsValidComponentChildren2 = _interopRequireDefault(_utilsValidComponentChildren);

var ROUND_PRECISION = 1000;

/**
 * Validate that children, if any, are instances of `<ProgressBar>`.
 */
function onlyProgressBar(props, propName, componentName) {
  var children = props[propName];
  if (!children) {
    return null;
  }

  var error = null;

  _react2['default'].Children.forEach(children, function (child) {
    if (error) {
      return;
    }

    if (child.type === ProgressBar) {
      // eslint-disable-line no-use-before-define
      return;
    }

    var childIdentifier = _react2['default'].isValidElement(child) ? child.type.displayName || child.type.name || child.type : child;
    error = new Error('Children of ' + componentName + ' can contain only ProgressBar ' + ('components. Found ' + childIdentifier + '.'));
  });

  return error;
}

var propTypes = {
  min: _react.PropTypes.number,
  now: _react.PropTypes.number,
  max: _react.PropTypes.number,
  label: _react.PropTypes.node,
  srOnly: _react.PropTypes.bool,
  striped: _react.PropTypes.bool,
  active: _react.PropTypes.bool,
  children: onlyProgressBar,

  /**
   * @private
   */
  isChild: _react.PropTypes.bool
};

var defaultProps = {
  min: 0,
  max: 100,
  active: false,
  isChild: false,
  srOnly: false,
  striped: false
};

function getPercentage(now, min, max) {
  var percentage = (now - min) / (max - min) * 100;
  return Math.round(percentage * ROUND_PRECISION) / ROUND_PRECISION;
}

var ProgressBar = (function (_React$Component) {
  _inherits(ProgressBar, _React$Component);

  function ProgressBar() {
    _classCallCheck(this, ProgressBar);

    _React$Component.apply(this, arguments);
  }

  ProgressBar.prototype.renderProgressBar = function renderProgressBar(_ref) {
    var _extends2;

    var min = _ref.min;
    var now = _ref.now;
    var max = _ref.max;
    var label = _ref.label;
    var srOnly = _ref.srOnly;
    var striped = _ref.striped;
    var active = _ref.active;
    var className = _ref.className;
    var style = _ref.style;

    var props = _objectWithoutProperties(_ref, ['min', 'now', 'max', 'label', 'srOnly', 'striped', 'active', 'className', 'style']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var classes = _extends({}, _utilsBootstrapUtils.getClassSet(bsProps), (_extends2 = {
      active: active
    }, _extends2[_utilsBootstrapUtils.prefix(bsProps, 'striped')] = active || striped, _extends2));

    return _react2['default'].createElement(
      'div',
      _extends({}, elementProps, {
        role: 'progressbar',
        className: _classnames2['default'](className, classes),
        style: _extends({ width: getPercentage(now, min, max) + '%' }, style),
        'aria-valuenow': now,
        'aria-valuemin': min,
        'aria-valuemax': max
      }),
      srOnly ? _react2['default'].createElement(
        'span',
        { className: 'sr-only' },
        label
      ) : label
    );
  };

  ProgressBar.prototype.render = function render() {
    var _props = this.props;
    var isChild = _props.isChild;

    var props = _objectWithoutProperties(_props, ['isChild']);

    if (isChild) {
      return this.renderProgressBar(props);
    }

    var min = props.min;
    var now = props.now;
    var max = props.max;
    var label = props.label;
    var srOnly = props.srOnly;
    var striped = props.striped;
    var active = props.active;
    var bsClass = props.bsClass;
    var bsStyle = props.bsStyle;
    var className = props.className;
    var children = props.children;

    var wrapperProps = _objectWithoutProperties(props, ['min', 'now', 'max', 'label', 'srOnly', 'striped', 'active', 'bsClass', 'bsStyle', 'className', 'children']);

    return _react2['default'].createElement(
      'div',
      _extends({}, wrapperProps, {
        className: _classnames2['default'](className, 'progress')
      }),
      children ? _utilsValidComponentChildren2['default'].map(children, function (child) {
        return _react.cloneElement(child, { isChild: true });
      }) : this.renderProgressBar({
        min: min, now: now, max: max, label: label, srOnly: srOnly, striped: striped, active: active, bsClass: bsClass, bsStyle: bsStyle
      })
    );
  };

  return ProgressBar;
})(_react2['default'].Component);

ProgressBar.propTypes = propTypes;
ProgressBar.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsClass('progress-bar', _utilsBootstrapUtils.bsStyles(_Object$values(_utilsStyleConfig.State), ProgressBar));
module.exports = exports['default'];