'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactPropTypesLibIsRequiredForA11y = require('react-prop-types/lib/isRequiredForA11y');

var _reactPropTypesLibIsRequiredForA11y2 = _interopRequireDefault(_reactPropTypesLibIsRequiredForA11y);

var _uncontrollable = require('uncontrollable');

var _uncontrollable2 = _interopRequireDefault(_uncontrollable);

var _Nav = require('./Nav');

var _Nav2 = _interopRequireDefault(_Nav);

var _NavItem = require('./NavItem');

var _NavItem2 = _interopRequireDefault(_NavItem);

var _TabContainer = require('./TabContainer');

var _TabContainer2 = _interopRequireDefault(_TabContainer);

var _TabContent = require('./TabContent');

var _TabContent2 = _interopRequireDefault(_TabContent);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var _utilsValidComponentChildren = require('./utils/ValidComponentChildren');

var _utilsValidComponentChildren2 = _interopRequireDefault(_utilsValidComponentChildren);

var TabContainer = _TabContainer2['default'].ControlledComponent;

var propTypes = {
  /**
   * Mark the Tab with a matching `eventKey` as active.
   *
   * @controllable onSelect
   */
  activeKey: _react2['default'].PropTypes.any,

  /**
   * Navigation style
   */
  bsStyle: _react2['default'].PropTypes.oneOf(['tabs', 'pills']),

  animation: _react2['default'].PropTypes.bool,

  id: _reactPropTypesLibIsRequiredForA11y2['default'](_react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.string, _react2['default'].PropTypes.number])),

  /**
   * Callback fired when a Tab is selected.
   *
   * ```js
   * function (
   * 	Any eventKey,
   * 	SyntheticEvent event?
   * )
   * ```
   *
   * @controllable activeKey
   */
  onSelect: _react2['default'].PropTypes.func,

  /**
   * Unmount tabs (remove it from the DOM) when it is no longer visible
   */
  unmountOnExit: _react2['default'].PropTypes.bool
};

var defaultProps = {
  bsStyle: 'tabs',
  animation: true,
  unmountOnExit: false
};

function getDefaultActiveKey(children) {
  var defaultActiveKey = undefined;
  _utilsValidComponentChildren2['default'].forEach(children, function (child) {
    if (defaultActiveKey == null) {
      defaultActiveKey = child.props.eventKey;
    }
  });

  return defaultActiveKey;
}

var Tabs = (function (_React$Component) {
  _inherits(Tabs, _React$Component);

  function Tabs() {
    _classCallCheck(this, Tabs);

    _React$Component.apply(this, arguments);
  }

  Tabs.prototype.renderTab = function renderTab(child) {
    var _child$props = child.props;
    var title = _child$props.title;
    var eventKey = _child$props.eventKey;
    var disabled = _child$props.disabled;
    var tabClassName = _child$props.tabClassName;

    if (title == null) {
      return null;
    }

    return _react2['default'].createElement(
      _NavItem2['default'],
      {
        eventKey: eventKey,
        disabled: disabled,
        className: tabClassName
      },
      title
    );
  };

  Tabs.prototype.render = function render() {
    var _props = this.props;
    var id = _props.id;
    var onSelect = _props.onSelect;
    var animation = _props.animation;
    var unmountOnExit = _props.unmountOnExit;
    var bsClass = _props.bsClass;
    var className = _props.className;
    var style = _props.style;
    var children = _props.children;
    var _props$activeKey = _props.activeKey;
    var activeKey = _props$activeKey === undefined ? getDefaultActiveKey(children) : _props$activeKey;

    var props = _objectWithoutProperties(_props, ['id', 'onSelect', 'animation', 'unmountOnExit', 'bsClass', 'className', 'style', 'children', 'activeKey']);

    return _react2['default'].createElement(
      TabContainer,
      {
        id: id,
        activeKey: activeKey,
        onSelect: onSelect,
        className: className,
        style: style
      },
      _react2['default'].createElement(
        'div',
        null,
        _react2['default'].createElement(
          _Nav2['default'],
          _extends({}, props, {
            role: 'tablist'
          }),
          _utilsValidComponentChildren2['default'].map(children, this.renderTab)
        ),
        _react2['default'].createElement(
          _TabContent2['default'],
          {
            bsClass: bsClass,
            animation: animation,
            unmountOnExit: unmountOnExit
          },
          children
        )
      )
    );
  };

  return Tabs;
})(_react2['default'].Component);

Tabs.propTypes = propTypes;
Tabs.defaultProps = defaultProps;

_utilsBootstrapUtils.bsClass('tab', Tabs);

exports['default'] = _uncontrollable2['default'](Tabs, { activeKey: 'onSelect' });
module.exports = exports['default'];