"use strict";

var _Object$entries = require("babel-runtime/core-js/object/entries")["default"];

exports.__esModule = true;
exports["default"] = splitComponentProps;

function splitComponentProps(props, Component) {
  var componentPropTypes = Component.propTypes;

  var parentProps = {};
  var childProps = {};

  _Object$entries(props).forEach(function (_ref) {
    var propName = _ref[0];
    var propValue = _ref[1];

    if (componentPropTypes[propName]) {
      parentProps[propName] = propValue;
    } else {
      childProps[propName] = propValue;
    }
  });

  return [parentProps, childProps];
}

module.exports = exports["default"];