import _extends from "@babel/runtime/helpers/esm/extends";
import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
import classNames from 'classnames';
import React from 'react';
import isRequiredForA11y from 'prop-types-extra/lib/isRequiredForA11y';
import { useBootstrapPrefix } from './ThemeProvider';
import PopoverTitle from './PopoverTitle';
import PopoverContent from './PopoverContent';
var defaultProps = {
  placement: 'right'
};
var Popover = React.forwardRef(function (_ref, ref) {
  var bsPrefix = _ref.bsPrefix,
      placement = _ref.placement,
      className = _ref.className,
      style = _ref.style,
      children = _ref.children,
      content = _ref.content,
      arrowProps = _ref.arrowProps,
      _ = _ref.scheduleUpdate,
      _1 = _ref.outOfBoundaries,
      props = _objectWithoutPropertiesLoose(_ref, ["bsPrefix", "placement", "className", "style", "children", "content", "arrowProps", "scheduleUpdate", "outOfBoundaries"]);

  var decoratedBsPrefix = useBootstrapPrefix(bsPrefix, 'popover');
  return React.createElement("div", _extends({
    ref: ref,
    role: "tooltip",
    style: style,
    "x-placement": placement,
    className: classNames(className, decoratedBsPrefix, "bs-popover-" + placement)
  }, props), React.createElement("div", _extends({
    className: "arrow"
  }, arrowProps)), content ? React.createElement(PopoverContent, null, children) : children);
});
Popover.defaultProps = defaultProps;
Popover.Title = PopoverTitle;
Popover.Content = PopoverContent;
export default Popover;