import _extends from "@babel/runtime/helpers/esm/extends";
import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
import classNames from 'classnames';
import React from 'react';
import { useBootstrapPrefix } from './ThemeProvider';
var TabContent = React.forwardRef(function (_ref, ref) {
  var bsPrefix = _ref.bsPrefix,
      _ref$as = _ref.as,
      Component = _ref$as === void 0 ? 'div' : _ref$as,
      className = _ref.className,
      props = _objectWithoutPropertiesLoose(_ref, ["bsPrefix", "as", "className"]);

  var decoratedBsPrefix = useBootstrapPrefix(bsPrefix, 'tab-content');
  return React.createElement(Component, _extends({
    ref: ref
  }, props, {
    className: classNames(className, decoratedBsPrefix)
  }));
});
export default TabContent;