import _extends from "@babel/runtime/helpers/esm/extends";
import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
import React, { useContext } from 'react';
import SelectableContext from './SelectableContext';
import AccordionContext from './AccordionContext';
var AccordionToggle = React.forwardRef(function (_ref, ref) {
  var _ref$as = _ref.as,
      Component = _ref$as === void 0 ? 'button' : _ref$as,
      children = _ref.children,
      eventKey = _ref.eventKey,
      _onClick = _ref.onClick,
      props = _objectWithoutPropertiesLoose(_ref, ["as", "children", "eventKey", "onClick"]);

  var contextEventKey = useContext(AccordionContext);
  var onSelect = useContext(SelectableContext);
  return React.createElement(Component, _extends({
    ref: ref,
    onClick: function onClick(e) {
      /* 
        Compare the event key in context with the given event key.
        If they are the same, then collapse the component.
      */
      var eventKeyPassed = eventKey === contextEventKey ? null : eventKey;
      onSelect(eventKeyPassed, e);
      if (_onClick) _onClick(e);
    }
  }, props), children);
});
export default AccordionToggle;