# pagination

A batteries included pagination component using bootstrap styles. This was
extracted from an older version of react-bootstrap as a migration path.

> **NOT ACTIVELY MAINTAINED:** We recommend you eventually migrate to a more
robust, better maintained solution, such as react-ultimate-pagination

It is a drop-in replacement for the old Pagination component in react-bootstrap (`<= 0.30.x`).

### Alternatives

For users of newer versions of React-Bootstrap we recommend something simpler and
more dedicated to providing proper pagination logic. One good general option is
`react-ultimate-pagination` which can be used with react-bootstrap components easily like:

```jsx
import React from 'react';
import Pagination from 'react-bootstrap/lib/Pagination';
import { createUltimatePagination, ITEM_TYPES } from 'react-ultimate-pagination';

export default createUltimatePagination({
  WrapperComponent: Pagination,
  itemTypeToComponent: {
    [ITEM_TYPES.PAGE]: ({value, isActive, onClick}) => (
      <Pagination.Item active={isActive}>{value}</Pagination.Item>
    ),
    [ITEM_TYPES.ELLIPSIS]: ({ isActive, onClick }) => (
      <Pagination.Ellipsis disabled={isActive} onClick={onClick} />
    ),
    [ITEM_TYPES.FIRST_PAGE_LINK]: ({ isActive, onClick }) => (
      <Pagination.First disabled={isActive} onClick={onClick} />
    ),
    [ITEM_TYPES.PREVIOUS_PAGE_LINK]: ({ isActive, onClick }) => (
      <Pagination.Prev disabled={isActive} onClick={onClick} />
    ),
    [ITEM_TYPES.NEXT_PAGE_LINK]: ({ isActive, onClick }) => (
      <Pagination.Next disabled={isActive} onClick={onClick} />
    ),
    [ITEM_TYPES.LAST_PAGE_LINK]: ({ isActive, onClick }) => (
      <Pagination.Last disabled={isActive} onClick={onClick} />
    ),
  },
});
```