import _extends from 'babel-runtime/helpers/extends';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import * as React from 'react';
import PopperJS from 'popper.js';

import { ManagerContext } from './Manager';
import { safeInvoke, unwrapArray } from './utils';

var initialStyle = {
  position: 'absolute',
  top: 0,
  left: 0,
  opacity: 0,
  pointerEvents: 'none'
};

var initialArrowStyle = {};

export var InnerPopper = function (_React$Component) {
  _inherits(InnerPopper, _React$Component);

  function InnerPopper() {
    var _temp, _this, _ret;

    _classCallCheck(this, InnerPopper);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.state = {
      data: undefined,
      placement: undefined
    }, _this.popperNode = null, _this.arrowNode = null, _this.setPopperNode = function (popperNode) {
      if (_this.popperNode === popperNode) return;

      safeInvoke(_this.props.innerRef, popperNode);
      _this.popperNode = popperNode;

      if (!_this.popperInstance) _this.updatePopperInstance();
    }, _this.setArrowNode = function (arrowNode) {
      if (_this.arrowNode === arrowNode) return;
      _this.arrowNode = arrowNode;

      if (!_this.popperInstance) _this.updatePopperInstance();
    }, _this.updateStateModifier = {
      enabled: true,
      order: 900,
      fn: function fn(data) {
        var placement = data.placement;

        _this.setState({ data: data, placement: placement }, placement !== _this.state.placement ? _this.scheduleUpdate : undefined);
        return data;
      }
    }, _this.getOptions = function () {
      return {
        placement: _this.props.placement,
        eventsEnabled: _this.props.eventsEnabled,
        positionFixed: _this.props.positionFixed,
        modifiers: _extends({}, _this.props.modifiers, {
          arrow: {
            enabled: !!_this.arrowNode,
            element: _this.arrowNode
          },
          applyStyle: { enabled: false },
          updateStateModifier: _this.updateStateModifier
        })
      };
    }, _this.getPopperStyle = function () {
      return !_this.popperNode || !_this.state.data ? initialStyle : _extends({
        position: _this.state.data.offsets.popper.position
      }, _this.state.data.styles);
    }, _this.getPopperPlacement = function () {
      return !_this.state.data ? undefined : _this.state.placement;
    }, _this.getArrowStyle = function () {
      return !_this.arrowNode || !_this.state.data ? initialArrowStyle : _this.state.data.arrowStyles;
    }, _this.getOutOfBoundariesState = function () {
      return _this.state.data ? _this.state.data.hide : undefined;
    }, _this.destroyPopperInstance = function () {
      if (!_this.popperInstance) return;

      _this.popperInstance.destroy();
      _this.popperInstance = null;
    }, _this.updatePopperInstance = function () {
      _this.destroyPopperInstance();

      var _this2 = _this,
          popperNode = _this2.popperNode;
      var referenceElement = _this.props.referenceElement;


      if (!referenceElement || !popperNode) return;

      _this.popperInstance = new PopperJS(referenceElement, popperNode, _this.getOptions());
    }, _this.scheduleUpdate = function () {
      if (_this.popperInstance) {
        _this.popperInstance.scheduleUpdate();
      }
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  InnerPopper.prototype.componentDidUpdate = function componentDidUpdate(prevProps, prevState) {
    // If the Popper.js options have changed, update the instance (destroy + create)
    if (this.props.placement !== prevProps.placement || this.props.referenceElement !== prevProps.referenceElement || this.props.positionFixed !== prevProps.positionFixed) {
      this.updatePopperInstance();
    } else if (this.props.eventsEnabled !== prevProps.eventsEnabled && this.popperInstance) {
      this.props.eventsEnabled ? this.popperInstance.enableEventListeners() : this.popperInstance.disableEventListeners();
    }

    // A placement difference in state means popper determined a new placement
    // apart from the props value. By the time the popper element is rendered with
    // the new position Popper has already measured it, if the place change triggers
    // a size change it will result in a misaligned popper. So we schedule an update to be sure.
    if (prevState.placement !== this.state.placement) {
      this.scheduleUpdate();
    }
  };

  InnerPopper.prototype.componentWillUnmount = function componentWillUnmount() {
    this.destroyPopperInstance();
  };

  InnerPopper.prototype.render = function render() {
    return unwrapArray(this.props.children)({
      ref: this.setPopperNode,
      style: this.getPopperStyle(),
      placement: this.getPopperPlacement(),
      outOfBoundaries: this.getOutOfBoundariesState(),
      scheduleUpdate: this.scheduleUpdate,
      arrowProps: {
        ref: this.setArrowNode,
        style: this.getArrowStyle()
      }
    });
  };

  return InnerPopper;
}(React.Component);

InnerPopper.defaultProps = {
  placement: 'bottom',
  eventsEnabled: true,
  referenceElement: undefined,
  positionFixed: false
};
var placements = PopperJS.placements;
export { placements };

export default function Popper(props) {
  return React.createElement(
    ManagerContext.Consumer,
    null,
    function (_ref) {
      var referenceNode = _ref.referenceNode;
      return React.createElement(InnerPopper, _extends({ referenceElement: referenceNode }, props));
    }
  );
}