'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _invariant = require('invariant');

var _invariant2 = _interopRequireDefault(_invariant);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var createBroadcast = function createBroadcast(initialValue) {
  var listeners = [];
  var currentValue = initialValue;

  return {
    publish: function publish(value) {
      currentValue = value;
      listeners.forEach(function (listener) {
        return listener(currentValue);
      });
    },
    subscribe: function subscribe(listener) {
      listeners.push(listener);

      // Publish to this subscriber once immediately.
      listener(currentValue);

      return function () {
        return listeners = listeners.filter(function (item) {
          return item !== listener;
        });
      };
    }
  };
};

/**
 * A <Broadcast> provides a generic way for descendants to "subscribe"
 * to some value that changes over time, bypassing any intermediate
 * shouldComponentUpdate's in the hierarchy. It puts all subscription
 * functions on context.broadcasts, keyed by "channel".
 *
 * To use it, a subscriber must opt-in to context.broadcasts. See the
 * <Subscriber> component for a reference implementation.
 */

var Broadcast = function (_React$Component) {
  _inherits(Broadcast, _React$Component);

  function Broadcast() {
    var _temp, _this, _ret;

    _classCallCheck(this, Broadcast);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.broadcast = createBroadcast(_this.props.value), _temp), _possibleConstructorReturn(_this, _ret);
  }

  Broadcast.prototype.getBroadcastsContext = function getBroadcastsContext() {
    var _extends2;

    var channel = this.props.channel;
    var broadcasts = this.context.broadcasts;


    return _extends({}, broadcasts, (_extends2 = {}, _extends2[channel] = this.broadcast.subscribe, _extends2));
  };

  Broadcast.prototype.getChildContext = function getChildContext() {
    return {
      broadcasts: this.getBroadcastsContext()
    };
  };

  Broadcast.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    !(this.props.channel === nextProps.channel) ? process.env.NODE_ENV !== 'production' ? (0, _invariant2.default)(false, 'You cannot change <Broadcast channel>') : (0, _invariant2.default)(false) : void 0;

    if (this.props.value !== nextProps.value) this.broadcast.publish(nextProps.value);
  };

  Broadcast.prototype.render = function render() {
    return _react2.default.Children.only(this.props.children);
  };

  return Broadcast;
}(_react2.default.Component);

Broadcast.contextTypes = {
  broadcasts: _react.PropTypes.object
};
Broadcast.childContextTypes = {
  broadcasts: _react.PropTypes.object.isRequired
};


if (process.env.NODE_ENV !== 'production') {
  Broadcast.propTypes = {
    channel: _react.PropTypes.string.isRequired,
    children: _react.PropTypes.node.isRequired,
    value: _react.PropTypes.any
  };
}

exports.default = Broadcast;