'use strict';

exports.__esModule = true;

var _invariant = require('invariant');

var _invariant2 = _interopRequireDefault(_invariant);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * A <Subscriber> pulls the value for a channel off of context.broadcasts
 * and passes it to its children function.
 */
var Subscriber = function (_React$Component) {
  _inherits(Subscriber, _React$Component);

  function Subscriber() {
    var _temp, _this, _ret;

    _classCallCheck(this, Subscriber);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.state = {
      value: null
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  Subscriber.prototype.componentWillMount = function componentWillMount() {
    var _this2 = this;

    var channel = this.props.channel;


    if (this.context.broadcasts) {
      var subscribe = this.context.broadcasts[channel];

      !(typeof subscribe === 'function') ? process.env.NODE_ENV !== 'production' ? (0, _invariant2.default)(false, '<Subscriber channel="%s"> must be rendered in the context of a <Broadcast channel="%s">', channel, channel) : (0, _invariant2.default)(false) : void 0;

      this.unsubscribe = subscribe(function (value) {
        // This function will be called once immediately.
        _this2.setState({ value: value });
      });
    }
  };

  Subscriber.prototype.componentWillUnmount = function componentWillUnmount() {
    if (this.unsubscribe) this.unsubscribe();
  };

  Subscriber.prototype.render = function render() {
    return this.props.children(this.state.value);
  };

  return Subscriber;
}(_react2.default.Component);

Subscriber.contextTypes = {
  broadcasts: _react2.default.PropTypes.object
};


if (process.env.NODE_ENV !== 'production') {
  Subscriber.propTypes = {
    channel: _react.PropTypes.string.isRequired,
    children: _react.PropTypes.func.isRequired
  };
}

exports.default = Subscriber;