(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("react"));
	else if(typeof define === 'function' && define.amd)
		define(["react"], factory);
	else if(typeof exports === 'object')
		exports["ReactBroadcast"] = factory(require("react"));
	else
		root["ReactBroadcast"] = factory(root["React"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_3__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	exports.__esModule = true;
	exports.Subscriber = exports.Broadcast = undefined;

	var _Broadcast2 = __webpack_require__(1);

	var _Broadcast3 = _interopRequireDefault(_Broadcast2);

	var _Subscriber2 = __webpack_require__(4);

	var _Subscriber3 = _interopRequireDefault(_Subscriber2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	exports.Broadcast = _Broadcast3.default;
	exports.Subscriber = _Subscriber3.default;

/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	exports.__esModule = true;

	var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

	var _invariant = __webpack_require__(2);

	var _invariant2 = _interopRequireDefault(_invariant);

	var _react = __webpack_require__(3);

	var _react2 = _interopRequireDefault(_react);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var createBroadcast = function createBroadcast(initialValue) {
	  var listeners = [];
	  var currentValue = initialValue;

	  return {
	    publish: function publish(value) {
	      currentValue = value;
	      listeners.forEach(function (listener) {
	        return listener(currentValue);
	      });
	    },
	    subscribe: function subscribe(listener) {
	      listeners.push(listener);

	      // Publish to this subscriber once immediately.
	      listener(currentValue);

	      return function () {
	        return listeners = listeners.filter(function (item) {
	          return item !== listener;
	        });
	      };
	    }
	  };
	};

	/**
	 * A <Broadcast> provides a generic way for descendants to "subscribe"
	 * to some value that changes over time, bypassing any intermediate
	 * shouldComponentUpdate's in the hierarchy. It puts all subscription
	 * functions on context.broadcasts, keyed by "channel".
	 *
	 * To use it, a subscriber must opt-in to context.broadcasts. See the
	 * <Subscriber> component for a reference implementation.
	 */

	var Broadcast = function (_React$Component) {
	  _inherits(Broadcast, _React$Component);

	  function Broadcast() {
	    var _temp, _this, _ret;

	    _classCallCheck(this, Broadcast);

	    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
	      args[_key] = arguments[_key];
	    }

	    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.broadcast = createBroadcast(_this.props.value), _temp), _possibleConstructorReturn(_this, _ret);
	  }

	  Broadcast.prototype.getBroadcastsContext = function getBroadcastsContext() {
	    var _extends2;

	    var channel = this.props.channel;
	    var broadcasts = this.context.broadcasts;


	    return _extends({}, broadcasts, (_extends2 = {}, _extends2[channel] = this.broadcast.subscribe, _extends2));
	  };

	  Broadcast.prototype.getChildContext = function getChildContext() {
	    return {
	      broadcasts: this.getBroadcastsContext()
	    };
	  };

	  Broadcast.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
	    !(this.props.channel === nextProps.channel) ?  false ? (0, _invariant2.default)(false, 'You cannot change <Broadcast channel>') : (0, _invariant2.default)(false) : void 0;

	    if (this.props.value !== nextProps.value) this.broadcast.publish(nextProps.value);
	  };

	  Broadcast.prototype.render = function render() {
	    return _react2.default.Children.only(this.props.children);
	  };

	  return Broadcast;
	}(_react2.default.Component);

	Broadcast.contextTypes = {
	  broadcasts: _react.PropTypes.object
	};
	Broadcast.childContextTypes = {
	  broadcasts: _react.PropTypes.object.isRequired
	};


	if (false) {
	  Broadcast.propTypes = {
	    channel: _react.PropTypes.string.isRequired,
	    children: _react.PropTypes.node.isRequired,
	    value: _react.PropTypes.any
	  };
	}

	exports.default = Broadcast;

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copyright 2013-2015, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 */

	'use strict';

	/**
	 * Use invariant() to assert state which your program assumes to be true.
	 *
	 * Provide sprintf-style format (only %s is supported) and arguments
	 * to provide information about what broke and what you were
	 * expecting.
	 *
	 * The invariant message will be stripped in production, but the invariant
	 * will remain to ensure logic does not differ in production.
	 */

	var invariant = function(condition, format, a, b, c, d, e, f) {
	  if (false) {
	    if (format === undefined) {
	      throw new Error('invariant requires an error message argument');
	    }
	  }

	  if (!condition) {
	    var error;
	    if (format === undefined) {
	      error = new Error(
	        'Minified exception occurred; use the non-minified dev environment ' +
	        'for the full error message and additional helpful warnings.'
	      );
	    } else {
	      var args = [a, b, c, d, e, f];
	      var argIndex = 0;
	      error = new Error(
	        format.replace(/%s/g, function() { return args[argIndex++]; })
	      );
	      error.name = 'Invariant Violation';
	    }

	    error.framesToPop = 1; // we don't care about invariant's own frame
	    throw error;
	  }
	};

	module.exports = invariant;


/***/ },
/* 3 */
/***/ function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_3__;

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	exports.__esModule = true;

	var _invariant = __webpack_require__(2);

	var _invariant2 = _interopRequireDefault(_invariant);

	var _react = __webpack_require__(3);

	var _react2 = _interopRequireDefault(_react);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	/**
	 * A <Subscriber> pulls the value for a channel off of context.broadcasts
	 * and passes it to its children function.
	 */
	var Subscriber = function (_React$Component) {
	  _inherits(Subscriber, _React$Component);

	  function Subscriber() {
	    var _temp, _this, _ret;

	    _classCallCheck(this, Subscriber);

	    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
	      args[_key] = arguments[_key];
	    }

	    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.state = {
	      value: null
	    }, _temp), _possibleConstructorReturn(_this, _ret);
	  }

	  Subscriber.prototype.componentWillMount = function componentWillMount() {
	    var _this2 = this;

	    var channel = this.props.channel;


	    if (this.context.broadcasts) {
	      var subscribe = this.context.broadcasts[channel];

	      !(typeof subscribe === 'function') ?  false ? (0, _invariant2.default)(false, '<Subscriber channel="%s"> must be rendered in the context of a <Broadcast channel="%s">', channel, channel) : (0, _invariant2.default)(false) : void 0;

	      this.unsubscribe = subscribe(function (value) {
	        // This function will be called once immediately.
	        _this2.setState({ value: value });
	      });
	    }
	  };

	  Subscriber.prototype.componentWillUnmount = function componentWillUnmount() {
	    if (this.unsubscribe) this.unsubscribe();
	  };

	  Subscriber.prototype.render = function render() {
	    return this.props.children(this.state.value);
	  };

	  return Subscriber;
	}(_react2.default.Component);

	Subscriber.contextTypes = {
	  broadcasts: _react2.default.PropTypes.object
	};


	if (false) {
	  Subscriber.propTypes = {
	    channel: _react.PropTypes.string.isRequired,
	    children: _react.PropTypes.func.isRequired
	  };
	}

	exports.default = Subscriber;

/***/ }
/******/ ])
});
;