function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import Days from './MonthView/Days';
import Weekdays from './MonthView/Weekdays';
import WeekNumbers from './MonthView/WeekNumbers';
import { CALENDAR_TYPES } from './shared/const';
import { isCalendarType, isMaxDate, isMinDate, isValue } from './shared/propTypes';

function getCalendarTypeFromLocale(locale) {
  switch (locale) {
    case 'en-CA':
    case 'en-US':
    case 'es-AR':
    case 'es-BO':
    case 'es-CL':
    case 'es-CO':
    case 'es-CR':
    case 'es-DO':
    case 'es-EC':
    case 'es-GT':
    case 'es-HN':
    case 'es-MX':
    case 'es-NI':
    case 'es-PA':
    case 'es-PE':
    case 'es-PR':
    case 'es-SV':
    case 'es-VE':
    case 'pt-BR':
      return CALENDAR_TYPES.US;
    // ar-LB, ar-MA intentionally missing

    case 'ar':
    case 'ar-AE':
    case 'ar-BH':
    case 'ar-DZ':
    case 'ar-EG':
    case 'ar-IQ':
    case 'ar-JO':
    case 'ar-KW':
    case 'ar-LY':
    case 'ar-OM':
    case 'ar-QA':
    case 'ar-SA':
    case 'ar-SD':
    case 'ar-SY':
    case 'ar-YE':
    case 'dv':
    case 'dv-MV':
    case 'ps':
    case 'ps-AR':
      return CALENDAR_TYPES.ARABIC;

    case 'he':
    case 'he-IL':
      return CALENDAR_TYPES.HEBREW;

    default:
      return CALENDAR_TYPES.ISO_8601;
  }
}

export default function MonthView(props) {
  var activeStartDate = props.activeStartDate,
      locale = props.locale,
      onMouseLeave = props.onMouseLeave,
      showFixedNumberOfWeeks = props.showFixedNumberOfWeeks;

  var calendarTypeProps = props.calendarType,
      formatShortWeekday = props.formatShortWeekday,
      onClickWeekNumber = props.onClickWeekNumber,
      showWeekNumbers = props.showWeekNumbers,
      childProps = _objectWithoutProperties(props, ["calendarType", "formatShortWeekday", "onClickWeekNumber", "showWeekNumbers"]);

  var calendarType = calendarTypeProps || getCalendarTypeFromLocale(locale);

  function renderWeekdays() {
    return React.createElement(Weekdays, {
      calendarType: calendarType,
      formatShortWeekday: formatShortWeekday,
      locale: locale,
      onMouseLeave: onMouseLeave
    });
  }

  function renderWeekNumbers() {
    if (!showWeekNumbers) {
      return null;
    }

    return React.createElement(WeekNumbers, {
      activeStartDate: activeStartDate,
      calendarType: calendarType,
      onClickWeekNumber: onClickWeekNumber,
      onMouseLeave: onMouseLeave,
      showFixedNumberOfWeeks: showFixedNumberOfWeeks
    });
  }

  function renderDays() {
    return React.createElement(Days, _extends({
      calendarType: calendarType
    }, childProps));
  }

  var className = 'react-calendar__month-view';
  return React.createElement("div", {
    className: [className, showWeekNumbers ? "".concat(className, "--weekNumbers") : ''].join(' ')
  }, React.createElement("div", {
    style: {
      display: 'flex',
      alignItems: 'flex-end'
    }
  }, renderWeekNumbers(), React.createElement("div", {
    style: {
      flexGrow: 1,
      width: '100%'
    }
  }, renderWeekdays(), renderDays())));
}
MonthView.propTypes = {
  activeStartDate: PropTypes.instanceOf(Date).isRequired,
  calendarType: isCalendarType,
  formatShortWeekday: PropTypes.func,
  locale: PropTypes.string,
  maxDate: isMaxDate,
  minDate: isMinDate,
  onChange: PropTypes.func,
  onClickWeekNumber: PropTypes.func,
  onMouseLeave: PropTypes.func,
  setActiveRange: PropTypes.func,
  showFixedNumberOfWeeks: PropTypes.bool,
  showNeighboringMonth: PropTypes.bool,
  showWeekNumbers: PropTypes.bool,
  value: isValue,
  valueType: PropTypes.string
};