import React from 'react';
import { formatMonthYear as defaultFormatMonthYear, formatYear as defaultFormatYear } from '../shared/dateFormatter.js';
import type { Action, NavigationLabelFunc, RangeType } from '../shared/types.js';
type NavigationProps = {
    activeStartDate: Date;
    drillUp: () => void;
    formatMonthYear?: typeof defaultFormatMonthYear;
    formatYear?: typeof defaultFormatYear;
    locale?: string;
    maxDate?: Date;
    minDate?: Date;
    navigationAriaLabel?: string;
    navigationAriaLive?: 'off' | 'polite' | 'assertive';
    navigationLabel?: NavigationLabelFunc;
    next2AriaLabel?: string;
    next2Label?: React.ReactNode;
    nextAriaLabel?: string;
    nextLabel?: React.ReactNode;
    prev2AriaLabel?: string;
    prev2Label?: React.ReactNode;
    prevAriaLabel?: string;
    prevLabel?: React.ReactNode;
    setActiveStartDate: (nextActiveStartDate: Date, action: Action) => void;
    showDoubleView?: boolean;
    view: RangeType;
    views: string[];
};
export default function Navigation({ activeStartDate, drillUp, formatMonthYear, formatYear, locale, maxDate, minDate, navigationAriaLabel, navigationAriaLive, navigationLabel, next2AriaLabel, next2Label, nextAriaLabel, nextLabel, prev2AriaLabel, prev2Label, prevAriaLabel, prevLabel, setActiveStartDate, showDoubleView, view, views, }: NavigationProps): JSX.Element;
export {};
