import React from 'react';
import Tile from '../Tile.js';
import { formatDay as defaultFormatDay, formatLongDate as defaultFormatLongDate } from '../shared/dateFormatter.js';
import type { CalendarType, DeprecatedCalendarType } from '../shared/types.js';
type DayProps = {
    calendarType?: CalendarType | DeprecatedCalendarType;
    classes?: string[];
    currentMonthIndex: number;
    formatDay?: typeof defaultFormatDay;
    formatLongDate?: typeof defaultFormatLongDate;
} & Omit<React.ComponentProps<typeof Tile>, 'children' | 'formatAbbr' | 'maxDateTransform' | 'minDateTransform' | 'view'>;
export default function Day({ calendarType: calendarTypeOrDeprecatedCalendarType, classes, currentMonthIndex, formatDay, formatLongDate, ...otherProps }: DayProps): JSX.Element;
export {};
