import React from 'react';
import type { CalendarType, ClassName, DeprecatedCalendarType, Detail, LooseValue, NavigationLabelFunc, OnArgs, OnClickFunc, OnClickWeekNumberFunc, TileClassNameFunc, TileContentFunc, TileDisabledFunc, Value, View } from './shared/types.js';
import type { formatDay as defaultFormatDay, formatLongDate as defaultFormatLongDate, formatMonth as defaultFormatMonth, formatMonthYear as defaultFormatMonthYear, formatShortWeekday as defaultFormatShortWeekday, formatWeekday as defaultFormatWeekday, formatYear as defaultFormatYear } from './shared/dateFormatter.js';
export type CalendarProps = {
    activeStartDate?: Date;
    allowPartialRange?: boolean;
    calendarType?: CalendarType | DeprecatedCalendarType;
    className?: ClassName;
    defaultActiveStartDate?: Date;
    defaultValue?: LooseValue;
    defaultView?: View;
    formatDay?: typeof defaultFormatDay;
    formatLongDate?: typeof defaultFormatLongDate;
    formatMonth?: typeof defaultFormatMonth;
    formatMonthYear?: typeof defaultFormatMonthYear;
    formatShortWeekday?: typeof defaultFormatShortWeekday;
    formatWeekday?: typeof defaultFormatWeekday;
    formatYear?: typeof defaultFormatYear;
    goToRangeStartOnSelect?: boolean;
    inputRef?: React.Ref<HTMLDivElement>;
    locale?: string;
    maxDate?: Date;
    maxDetail?: Detail;
    minDate?: Date;
    minDetail?: Detail;
    navigationAriaLabel?: string;
    navigationAriaLive?: 'off' | 'polite' | 'assertive';
    navigationLabel?: NavigationLabelFunc;
    next2AriaLabel?: string;
    next2Label?: React.ReactNode;
    nextAriaLabel?: string;
    nextLabel?: React.ReactNode;
    onActiveStartDateChange?: ({ action, activeStartDate, value, view }: OnArgs) => void;
    onChange?: (value: Value, event: React.MouseEvent<HTMLButtonElement>) => void;
    onClickDay?: OnClickFunc;
    onClickDecade?: OnClickFunc;
    onClickMonth?: OnClickFunc;
    onClickWeekNumber?: OnClickWeekNumberFunc;
    onClickYear?: OnClickFunc;
    onDrillDown?: ({ action, activeStartDate, value, view }: OnArgs) => void;
    onDrillUp?: ({ action, activeStartDate, value, view }: OnArgs) => void;
    onViewChange?: ({ action, activeStartDate, value, view }: OnArgs) => void;
    prev2AriaLabel?: string;
    prev2Label?: React.ReactNode;
    prevAriaLabel?: string;
    prevLabel?: React.ReactNode;
    returnValue?: 'start' | 'end' | 'range';
    selectRange?: boolean;
    showDoubleView?: boolean;
    showFixedNumberOfWeeks?: boolean;
    showNavigation?: boolean;
    showNeighboringMonth?: boolean;
    showWeekNumbers?: boolean;
    tileClassName?: TileClassNameFunc | ClassName;
    tileContent?: TileContentFunc | React.ReactNode;
    tileDisabled?: TileDisabledFunc;
    value?: LooseValue;
    view?: View;
};
declare const Calendar: React.ForwardRefExoticComponent<CalendarProps & React.RefAttributes<unknown>>;
export default Calendar;
