import React from 'react';
import type { ClassName, TileClassNameFunc, TileContentFunc, TileDisabledFunc, View } from './shared/types.js';
type TileProps = {
    activeStartDate: Date;
    children: React.ReactNode;
    classes?: string[];
    date: Date;
    formatAbbr?: (locale: string | undefined, date: Date) => string;
    locale?: string;
    maxDate?: Date;
    maxDateTransform: (date: Date) => Date;
    minDate?: Date;
    minDateTransform: (date: Date) => Date;
    onClick?: (date: Date, event: React.MouseEvent<HTMLButtonElement>) => void;
    onMouseOver?: (date: Date) => void;
    style?: React.CSSProperties;
    tileClassName?: TileClassNameFunc | ClassName;
    tileContent?: TileContentFunc | React.ReactNode;
    tileDisabled?: TileDisabledFunc;
    view: View;
};
export default function Tile(props: TileProps): JSX.Element;
export {};
