'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsPureRenderMixin = require('react-addons-pure-render-mixin');

var _reactMotion = require('react-motion');

var _reactHeight = require('react-height');

var _reactHeight2 = _interopRequireDefault(_reactHeight);

var Collapse = _react2['default'].createClass({
  displayName: 'Collapse',

  propTypes: {
    isOpened: _react2['default'].PropTypes.bool.isRequired,
    children: _react2['default'].PropTypes.node.isRequired,
    fixedHeight: _react2['default'].PropTypes.number,
    style: _react2['default'].PropTypes.object,
    springConfig: _react2['default'].PropTypes.arrayOf(_react2['default'].PropTypes.number)
  },

  getDefaultProps: function getDefaultProps() {
    return { fixedHeight: -1, style: {} };
  },

  getInitialState: function getInitialState() {
    return { height: -1 };
  },

  componentWillMount: function componentWillMount() {
    this.height = '0.0';
  },

  shouldComponentUpdate: _reactAddonsPureRenderMixin.shouldComponentUpdate,

  onHeightReady: function onHeightReady(height) {
    this.setState({ height: height });
  },

  renderFixed: function renderFixed() {
    var _props = this.props;
    var isOpened = _props.isOpened;
    var style = _props.style;
    var children = _props.children;
    var fixedHeight = _props.fixedHeight;
    var springConfig = _props.springConfig;

    var props = _objectWithoutProperties(_props, ['isOpened', 'style', 'children', 'fixedHeight', 'springConfig']);

    return _react2['default'].createElement(
      _reactMotion.Motion,
      {
        defaultStyle: { height: 0 },
        style: { height: (0, _reactMotion.spring)(isOpened ? fixedHeight : 0, springConfig) } },
      function (_ref) {
        var height = _ref.height;
        return !isOpened && parseFloat(height).toFixed(1) === '0.0' ? null : _react2['default'].createElement(
          'div',
          _extends({ style: _extends({}, style, { height: height, overflow: 'hidden' }) }, props),
          children
        );
      }
    );
  },

  render: function render() {
    var _this = this;

    var _props2 = this.props;
    var isOpened = _props2.isOpened;
    var style = _props2.style;
    var children = _props2.children;
    var fixedHeight = _props2.fixedHeight;
    var springConfig = _props2.springConfig;

    var props = _objectWithoutProperties(_props2, ['isOpened', 'style', 'children', 'fixedHeight', 'springConfig']);

    if (fixedHeight > -1) {
      return this.renderFixed();
    }

    var height = this.state.height;

    var stringHeight = parseFloat(height).toFixed(1);

    // Cache Content so it is not re-rendered on each animation step
    var content = _react2['default'].createElement(
      _reactHeight2['default'],
      { onHeightReady: this.onHeightReady },
      children
    );

    return _react2['default'].createElement(
      _reactMotion.Motion,
      {
        defaultStyle: { height: 0 },
        style: { height: (0, _reactMotion.spring)(isOpened ? height : 0, springConfig) } },
      function (st) {
        _this.height = Math.max(0, parseFloat(st.height)).toFixed(1);

        // TODO: this should be done using onEnd from ReactMotion, which is not yet implemented
        // See https://github.com/chenglou/react-motion/issues/235
        if (!isOpened && _this.height === '0.0') {
          return null;
        }

        var newStyle = isOpened && _this.height === stringHeight ? { height: 'auto' } : {
          height: st.height, overflow: 'hidden'
        };

        return _react2['default'].createElement(
          'div',
          _extends({ style: _extends({}, style, newStyle) }, props),
          content
        );
      }
    );
  }
});

exports['default'] = Collapse;
module.exports = exports['default'];
//# sourceMappingURL=Collapse.js.map