'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _ReactComponentWithPureRenderMixin = require('react/lib/ReactComponentWithPureRenderMixin');

var _reactMotion = require('react-motion');

var _reactHeight = require('react-height');

var _reactHeight2 = _interopRequireDefault(_reactHeight);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var PRECISION = 0.5;

var stringHeight = function stringHeight(height) {
  return Math.max(0, parseFloat(height)).toFixed(1);
};

var Collapse = _react2.default.createClass({
  displayName: 'Collapse',

  propTypes: {
    isOpened: _react2.default.PropTypes.bool.isRequired,
    children: _react2.default.PropTypes.node.isRequired,
    fixedHeight: _react2.default.PropTypes.number,
    style: _react2.default.PropTypes.object, // eslint-disable-line react/forbid-prop-types
    springConfig: _react2.default.PropTypes.objectOf(_react2.default.PropTypes.number),
    keepCollapsedContent: _react2.default.PropTypes.bool,
    onRest: _react2.default.PropTypes.func,
    onHeightReady: _react2.default.PropTypes.func
  },

  getDefaultProps: function getDefaultProps() {
    return {
      fixedHeight: -1,
      style: {},
      keepCollapsedContent: false,
      onHeightReady: function onHeightReady() {} // eslint-disable-line no-empty-function
    };
  },
  getInitialState: function getInitialState() {
    return { height: -1, isOpenedChanged: false };
  },
  componentWillMount: function componentWillMount() {
    this.height = stringHeight(0);
    this.renderStatic = true;
  },
  componentWillReceiveProps: function componentWillReceiveProps(_ref) {
    var isOpened = _ref.isOpened;

    this.setState({ isOpenedChanged: isOpened !== this.props.isOpened });
  },


  shouldComponentUpdate: _ReactComponentWithPureRenderMixin.shouldComponentUpdate,

  componentDidUpdate: function componentDidUpdate(_ref2) {
    var isOpened = _ref2.isOpened;

    if (isOpened !== this.props.isOpened) {
      var report = this.props.isOpened ? this.state.height : 0;

      this.props.onHeightReady(report);
    }
  },
  onHeightReady: function onHeightReady(height) {
    var _props = this.props;
    var isOpened = _props.isOpened;
    var keepCollapsedContent = _props.keepCollapsedContent;
    var onHeightReady = _props.onHeightReady;


    if (this.renderStatic && isOpened) {
      this.height = stringHeight(height);
    }
    if (keepCollapsedContent) {
      this.setState({ height: height });
    } else {
      this.setState({ height: isOpened || !this.renderStatic ? height : 0 });
    }

    var reportHeight = isOpened ? height : 0;

    if (this.state.height !== reportHeight) {
      onHeightReady(reportHeight);
    }
  },
  getMotionHeight: function getMotionHeight(height) {
    var _props2 = this.props;
    var isOpened = _props2.isOpened;
    var springConfig = _props2.springConfig;
    var isOpenedChanged = this.state.isOpenedChanged;


    var newHeight = isOpened ? Math.max(0, parseFloat(height)).toFixed(1) : stringHeight(0);

    // No need to animate if content is closed and it was closed previously
    // Also no need to animate if height did not change
    var skipAnimation = !isOpenedChanged && !isOpened || this.height === newHeight;

    var springHeight = (0, _reactMotion.spring)(isOpened ? Math.max(0, height) : 0, _extends({
      precision: PRECISION
    }, springConfig));
    var instantHeight = isOpened ? Math.max(0, height) : 0;

    return skipAnimation ? instantHeight : springHeight;
  },
  renderFixed: function renderFixed() {
    var _this = this;

    var _props3 = this.props;
    var _springConfig = _props3.springConfig;
    var _onHeightReady = _props3.onHeightReady;
    var _onRest = _props3.onRest;
    var isOpened = _props3.isOpened;
    var style = _props3.style;
    var children = _props3.children;
    var fixedHeight = _props3.fixedHeight;
    var keepCollapsedContent = _props3.keepCollapsedContent;

    var props = _objectWithoutProperties(_props3, ['springConfig', 'onHeightReady', 'onRest', 'isOpened', 'style', 'children', 'fixedHeight', 'keepCollapsedContent']);

    if (this.renderStatic) {
      this.renderStatic = false;
      var newStyle = { overflow: 'hidden', height: isOpened ? fixedHeight : 0 };

      if (!keepCollapsedContent && !isOpened) {
        return null;
      }
      this.height = stringHeight(fixedHeight);
      return _react2.default.createElement(
        'div',
        _extends({ style: _extends({}, newStyle, style) }, props),
        children
      );
    }

    return _react2.default.createElement(
      _reactMotion.Motion,
      {
        defaultStyle: { height: isOpened ? 0 : fixedHeight },
        style: { height: this.getMotionHeight(fixedHeight) } },
      function (_ref3) {
        var height = _ref3.height;

        _this.height = stringHeight(height);

        // TODO: this should be done using onEnd from ReactMotion, which is not yet implemented
        // See https://github.com/chenglou/react-motion/issues/235
        if (!keepCollapsedContent && !isOpened && _this.height === stringHeight(0)) {
          return null;
        }

        var newStyle = { overflow: 'hidden', height: height };

        return _react2.default.createElement(
          'div',
          _extends({ style: _extends({}, newStyle, style) }, props),
          children
        );
      }
    );
  },
  render: function render() {
    var _this2 = this;

    var _props4 = this.props;
    var _springConfig = _props4.springConfig;
    var _onHeightReady = _props4.onHeightReady;
    var isOpened = _props4.isOpened;
    var style = _props4.style;
    var children = _props4.children;
    var fixedHeight = _props4.fixedHeight;
    var keepCollapsedContent = _props4.keepCollapsedContent;
    var onRest = _props4.onRest;

    var props = _objectWithoutProperties(_props4, ['springConfig', 'onHeightReady', 'isOpened', 'style', 'children', 'fixedHeight', 'keepCollapsedContent', 'onRest']);

    if (fixedHeight > -1) {
      return this.renderFixed();
    }

    var renderStatic = this.renderStatic;
    var height = this.state.height;

    var currentStringHeight = parseFloat(height).toFixed(1);

    if (height > -1 && renderStatic) {
      this.renderStatic = false;
    }

    // Cache Content so it is not re-rendered on each animation step
    var content = _react2.default.createElement(
      _reactHeight2.default,
      { onHeightReady: this.onHeightReady },
      children
    );

    if (renderStatic) {
      var newStyle = isOpened ? { height: 'auto' } : { overflow: 'hidden', height: 0 };

      if (!isOpened && height > -1) {
        if (!keepCollapsedContent) {
          return null;
        }
        return _react2.default.createElement(
          'div',
          _extends({ style: _extends({ height: 0, overflow: 'hidden' }, style) }, props),
          content
        );
      }

      return _react2.default.createElement(
        'div',
        _extends({ style: _extends({}, newStyle, style) }, props),
        content
      );
    }

    return _react2.default.createElement(
      _reactMotion.Motion,
      {
        defaultStyle: { height: Math.max(0, height) },
        onRest: onRest,
        style: { height: this.getMotionHeight(height) } },
      function (st) {
        _this2.height = stringHeight(st.height);

        // TODO: this should be done using onEnd from ReactMotion, which is not yet implemented
        // See https://github.com/chenglou/react-motion/issues/235
        if (!isOpened && _this2.height === '0.0') {
          if (!keepCollapsedContent) {
            return null;
          }
          return _react2.default.createElement(
            'div',
            _extends({ style: _extends({ height: 0, overflow: 'hidden' }, style) }, props),
            content
          );
        }

        var newStyle = isOpened && _this2.height === currentStringHeight ? { height: 'auto' } : {
          height: st.height, overflow: 'hidden'
        };

        return _react2.default.createElement(
          'div',
          _extends({ style: _extends({}, newStyle, style) }, props),
          content
        );
      }
    );
  }
});

exports.default = Collapse;
//# sourceMappingURL=Collapse.js.map