'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Collapse = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Collapse = exports.Collapse = function (_React$Component) {
  _inherits(Collapse, _React$Component);

  function Collapse() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Collapse);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Collapse.__proto__ || Object.getPrototypeOf(Collapse)).call.apply(_ref, [this].concat(args))), _this), _this.state = { height: 0 }, _this.onResize = function () {
      if (_this.sensor) {
        var innerHeight = _this.sensor.contentWindow.innerHeight;

        var height = Math.ceil(innerHeight);
        _this.setState({ height: height });
      }
    }, _this.onSensorRef = function (ref) {
      _this.sensor = ref;
    }, _this.raf = null, _this.sensor = null, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Collapse, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (this.sensor) {
        this.sensor.contentWindow.addEventListener('resize', this.onResize, false);
        this.raf = window.requestAnimationFrame(this.onResize);
      }
    }
  }, {
    key: 'shouldComponentUpdate',
    value: function shouldComponentUpdate(nextProps, nextState) {
      var _props = this.props,
          theme = _props.theme,
          isOpened = _props.isOpened,
          children = _props.children;
      var height = this.state.height;


      return children !== nextProps.children || isOpened !== nextProps.isOpened || height !== nextState.height || Object.keys(theme).some(function (c) {
        return theme[c] !== nextProps.theme[c];
      });
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this.raf !== null) {
        window.cancelAnimationFrame(this.raf);
        this.raf = null;
      }
      if (this.sensor) {
        this.sensor.contentWindow.removeEventListener('resize', this.onResize, false);
        this.sensor = null;
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          isOpened = _props2.isOpened,
          theme = _props2.theme,
          children = _props2.children;
      var height = this.state.height;


      return _react2.default.createElement(
        'div',
        {
          style: {
            height: isOpened ? height : 0,
            overflow: 'hidden',
            transition: 'height 200ms'
          },
          className: theme.container },
        _react2.default.createElement(
          'div',
          {
            style: {
              position: 'relative'
            },
            className: theme.content },
          _react2.default.createElement('iframe', {
            ref: this.onSensorRef,
            title: 'Element resize sensor',
            style: {
              display: 'block',
              position: 'absolute',
              top: 0,
              left: 0,
              width: '100%',
              height: '100%',
              overflow: 'hidden',
              border: 'none',
              background: 'transparent',
              pointerEvents: 'none',
              zIndex: -1
            },
            className: theme.sensor }),
          children
        )
      );
    }
  }]);

  return Collapse;
}(_react2.default.Component);

Collapse.defaultProps = {
  theme: _propTypes2.default.shape({
    container: 'ReactCollapse--container',
    content: 'ReactCollapse--content',
    sensor: 'ReactCollapse--sensor'
  })
};