import { bool } from 'prop-types';
import React from 'react';
import { findDOMNode } from 'react-dom';
import spyOnComponent from 'spy-on-component';
export var PropTypes = {
  autoFocus: bool
};
export default function makeAutoFocusable(instance) {
  spyOnComponent(instance, {
    componentDidMount: function componentDidMount() {
      var autoFocus = this.props.autoFocus;
      if (autoFocus) this.focus ? this.focus() : findDOMNode(this).focus();
    }
  });
}