import spyOnComponent from 'spy-on-component';
import mountManager from './mountManager';
export default function createTimeoutManager(componentInstance) {
  var isMounted = mountManager(componentInstance);
  var timers = Object.create(null);
  var manager;
  spyOnComponent(componentInstance, {
    componentWillUnmount: function componentWillUnmount() {
      for (var k in timers) {
        clearTimeout(timers[k]);
      }

      timers = null;
    }
  });
  return manager = {
    clear: function clear(key) {
      clearTimeout(timers[key]);
    },
    set: function set(key, fn, ms) {
      if (!isMounted()) return;
      manager.clear(key);
      timers[key] = setTimeout(fn, ms);
    }
  };
}