function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React, { Component } from 'react';
import PropTypes from 'prop-types';

var Ticks = function (_Component) {
  _inherits(Ticks, _Component);

  function Ticks() {
    _classCallCheck(this, Ticks);

    return _possibleConstructorReturn(this, _Component.apply(this, arguments));
  }

  Ticks.prototype.render = function render() {
    var _props = this.props,
        children = _props.children,
        values = _props.values,
        scale = _props.scale,
        count = _props.count,
        emitMouse = _props.emitMouse,
        emitTouch = _props.emitTouch;

    var ticks = (values ? values : scale.getTicks(count)).map(function (value) {
      return {
        id: '$$-' + value,
        value: value,
        percent: scale.getValue(value)
      };
    });

    var renderedChildren = children({ ticks: ticks, emitMouse: emitMouse, emitTouch: emitTouch });
    return renderedChildren && React.Children.only(renderedChildren);
  };

  return Ticks;
}(Component);

Ticks.propTypes = {
  /** @ignore */
  scale: PropTypes.object,
  /**
   * Approximate number of ticks you want to render.
   * If you supply your own ticks using the values prop this prop has no effect.
   */
  count: PropTypes.number,
  /**
   * The values prop should be an array of unique numbers.
   * Use this prop if you want to specify your own tick values instead of ticks generated by the slider.
   * The numbers should be valid numbers in the domain and correspond to the step value.
   * Invalid values will be coerced to the closet matching value in the domain.
   */
  values: PropTypes.array,
  /** @ignore */
  emitMouse: PropTypes.func,
  /** @ignore */
  emitTouch: PropTypes.func,
  /**
   * A function to render the ticks.
   * The function receives an object with an array of ticks.
   * `({ ticks  }): element`
   */
  children: PropTypes.func.isRequired
};

Ticks.defaultProps = {
  count: 10
};

export default Ticks;