'use strict';

var React = require('react');

var _require = require('react-bootstrap');

var Button = _require.Button;
var Modal = _require.Modal;


var Confirm = React.createClass({
    displayName: 'Confirm',

    propTypes: {
        body: React.PropTypes.node.isRequired,
        buttonText: React.PropTypes.node,
        cancelText: React.PropTypes.node,
        confirmBSStyle: React.PropTypes.string,
        confirmText: React.PropTypes.node,
        onConfirm: React.PropTypes.func.isRequired,
        title: React.PropTypes.node.isRequired,
        visible: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            cancelText: 'Cancel',
            confirmText: 'Confirm',
            confirmBSStyle: 'danger'
        };
    },
    getInitialState: function getInitialState() {
        if (!this.props.visible) {
            return {
                isOpened: false
            };
        } else {
            return {
                isOpened: true
            };
        }
    },
    onButtonClick: function onButtonClick() {
        this.setState({
            isOpened: true
        });
    },
    onClose: function onClose() {
        this.setState({
            isOpened: false
        });
    },
    onConfim: function onConfim() {
        this.setState({
            isOpened: false
        });
        this.props.onConfirm();
    },
    render: function render() {
        var modal = React.createElement(
            Modal,
            { show: this.state.isOpened, onHide: this.onClose },
            React.createElement(
                Modal.Header,
                null,
                React.createElement(
                    Modal.Title,
                    null,
                    this.props.title
                )
            ),
            React.createElement(
                Modal.Body,
                null,
                this.props.body
            ),
            React.createElement(
                Modal.Footer,
                null,
                React.createElement(
                    Button,
                    { bsStyle: 'default', onClick: this.onClose },
                    this.props.cancelText
                ),
                React.createElement(
                    Button,
                    { bsStyle: this.props.confirmBSStyle, onClick: this.onConfim },
                    this.props.confirmText
                )
            )
        );
        var content;
        if (this.props.children) {
            var btn = React.Children.only(this.props.children);
            content = React.cloneElement(btn, {
                onClick: this.onButtonClick,
                style: this.props.style
            }, btn.props.children, modal);
        } else {
            content = React.createElement(
                Button,
                { onClick: this.onButtonClick, style: this.props.style },
                this.props.buttonText,
                modal
            );
        }
        return content;
    }
});

module.exports = Confirm;