[![Build Status](https://drone.our.buildo.io/api/badges/buildo/react-cookie-banner/status.svg)](https://drone.our.buildo.io/buildo/react-cookie-banner) ![](https://img.shields.io/npm/v/react-cookie-banner.svg)

# React Cookie Banner

React Cookie banner which can be dismissed with just a scroll. Because fuck The Cookie Law that's why.

If you *really* want to annoy your users you can disable this feature (highly discouraged!).

```jsx
import CookieBanner from 'react-cookie-banner';

React.renderComponent(
  <div>
    <CookieBanner
      message='Yes, we use cookies. If you don't like it change website, we won't miss you!'
      onAccept={() => {}}
      cookie='user-has-accepted-cookies' />
  </div>,
  document.body
);
```

[Live Examples](http://react-components.buildo.io/#cookiebanner)

### Install
```
npm install --save react-cookie-banner
```

### API
You can see `CookieBanner`'s props in its own [README.md](https://github.com/buildo/react-cookie-banner/blob/master/src/README.md)

### Style
ReactCookieBanner by default uses its simple inline style. However you can easily disable it by passing

```jsx
<CookieBanner disableStyle={true} />
```

In this case you can style it using css classes. The banner is structured as follows:

```jsx
<div className={this.props.className + ' react-cookie-banner'}
  <span className='cookie-message'>
    {this.props.message}
    <a className='cookie-link'>
      Learn more
    </a>
  </span>
  <div className='button-close'>
    Got it
  </div>
</div>
```

You can also pass your own CustomCookieBanner as child component which will be rendered in replacement:

```jsx
<CookieBanner>
  <CustomCookieBanner {...myCustomProps} /> {/* rendered directly without any <div> wrapper */}
</CookieBanner>
```

Or you override the predefined inline-styles. This examples puts the message font back to normal weight and makes the banner slightly transparent:

```jsx
<CookieBanner
  styles={{
    banner: { backgroundColor: 'rgba(60, 60, 60, 0.8)' },
    message: { fontWeight: 400 }
  }}
  message='...'
/>
```

See `src/styleUtils.js` for which style objects are availble to be overridden.

### Cookie manipulation
react-cookie-banner uses **`universal-cookie`** to manipulate cookies.

You can import the `Cookies` class and use it as follows:

```js
import { Cookies } from 'react-cookie-banner';

const cookies = new Cookies(/* Your cookie header, on browser defaults to document.cookie */);

// simple set
cookie.set('test', 'a')
// complex set - cookie(name, value, ttl, path, domain, secure)
cookie.set('test', 'a', {
  expires: new Date(2020-05-04)
  path: '/api',
  domain: '*.example.com',
  secure: true
})
// get
cookies.get("test")
// destroy
cookies.remove("test", "", -1)
```

Please refer to [universal-cookie](https://github.com/reactivestack/cookies/tree/master/packages/universal-cookie#api---cookies-class) repo for more documentation.

### Server side rendering (universal)
react-cookie-banner supports SSR thanks to `react-cookie`.
If you want to support SSR, you should use the `CookieProvider` from `react-cookie` and the  `CookieBannerUniversal` wrapper:

```js
import { Cookies, CookiesProvider, CookieBannerUniversal } from 'react-cookie-banner';

const cookies = new Cookies(/* Your cookie header, on browser defaults to document.cookie */);

<CookiesProvider cookies={cookies}>
  <CookieBannerUniversal />
</CookiesProvider>
```

