/// <reference types="react" />
import * as React from 'react';
import * as PropTypes from 'prop-types';
export declare type Props = {
    /** message written inside default cookie banner */
    message?: string;
    /** called when user accepts cookies */
    onAccept: () => void;
    /** object with infos used to render a link to your cookie-policy page */
    link?: {
        msg?: string;
        url: string;
        target?: '_blank' | '_self' | '_parent' | '_top' | 'framename';
        rel?: string;
    };
    /** message written inside the button of the default cookie banner */
    buttonMessage?: string;
    /** className passed to close-icon */
    closeIcon?: string;
    /** pass `true` if you want to disable default style */
    disableStyle?: boolean;
    /** object with custom styles used to overwrite default ones */
    styles?: object;
    className?: string;
};
export declare const propTypes: {
    message: PropTypes.Requireable<any>;
    onAccept: PropTypes.Validator<any>;
    link: PropTypes.Requireable<any>;
    buttonMessage: PropTypes.Requireable<any>;
    closeIcon: PropTypes.Requireable<any>;
    disableStyle: PropTypes.Requireable<any>;
    styles: PropTypes.Requireable<any>;
    className: PropTypes.Requireable<any>;
};
/**
 * React Cookie banner template
 */
export default class BannerContent extends React.Component<Props> {
    static propTypes: {
        message: PropTypes.Requireable<any>;
        onAccept: PropTypes.Validator<any>;
        link: PropTypes.Requireable<any>;
        buttonMessage: PropTypes.Requireable<any>;
        closeIcon: PropTypes.Requireable<any>;
        disableStyle: PropTypes.Requireable<any>;
        styles: PropTypes.Requireable<any>;
        className: PropTypes.Requireable<any>;
    };
    getStyle: (style: "button" | "link" | "message" | "banner" | "icon") => any;
    templateCloseIcon: (className: string, onClick: () => void, style: React.CSSProperties) => JSX.Element;
    templateCloseButton: (buttonMessage: string, onClick: () => void, style: React.CSSProperties) => JSX.Element;
    templateLink: (style: React.CSSProperties, link?: {
        msg?: string | undefined;
        url: string;
        target?: "_blank" | "_self" | "_parent" | "_top" | "framename" | undefined;
        rel?: string | undefined;
    } | undefined) => JSX.Element | undefined;
    render(): JSX.Element;
}
