'use strict';

var React = require('react');
var $ = require('jquery');

require('cropper');
require('cropper/dist/cropper.css');

var Cropper = React.createClass({
  displayName: 'Cropper',

  propTypes: {
    // react cropper options
    src: React.PropTypes.string,

    // cropper options
    aspectRatio: React.PropTypes.number,
    crop: React.PropTypes.func,
    preview: React.PropTypes.string,
    strict: React.PropTypes.bool,
    responsive: React.PropTypes.bool,
    checkImageOrigin: React.PropTypes.bool,
    background: React.PropTypes.bool,
    modal: React.PropTypes.bool,
    guides: React.PropTypes.bool,
    highlight: React.PropTypes.bool,
    autoCrop: React.PropTypes.bool,
    autoCropArea: React.PropTypes.number,
    dragCrop: React.PropTypes.bool,
    movable: React.PropTypes.bool,
    resizable: React.PropTypes.bool,
    zoomable: React.PropTypes.bool,
    mouseWheelZoom: React.PropTypes.bool,
    touchDragZoom: React.PropTypes.bool,
    rotatable: React.PropTypes.bool,
    minContainerWidth: React.PropTypes.number,
    minContainerHeight: React.PropTypes.number,
    minCanvasWidth: React.PropTypes.number,
    minCanvasHeight: React.PropTypes.number,
    minCropBoxWidth: React.PropTypes.number,
    minCropBoxHeight: React.PropTypes.number,
    build: React.PropTypes.func,
    built: React.PropTypes.func,
    dragstart: React.PropTypes.func,
    dragmove: React.PropTypes.func,
    dragend: React.PropTypes.func,
    zoomin: React.PropTypes.func,
    zoomout: React.PropTypes.func
  },

  getDefaultProps: function getDefaultProps() {
    return {
      src: null
    };
  },

  componentDidMount: function componentDidMount() {
    this.$img = $(React.findDOMNode(this.refs.img));

    this.$img.cropper(this.props);
  },

  componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
    if (nextProps.src !== this.props.src) {
      this.replace(nextProps.src);
    }
    if (nextProps.aspectRatio !== this.props.aspectRatio) {
      this.setAspectRatio(nextProps.aspectRatio);
    }
  },

  move: function move(offsetX, offsetY) {
    return this.$img.cropper('move', offsetX, offsetY);
  },

  zoom: function zoom(ratio) {
    return this.$img.cropper('zoom', ratio);
  },

  rotate: function rotate(degree) {
    return this.$img.cropper('rotate', degree);
  },

  enable: function enable() {
    return this.$img.cropper('enable');
  },

  disable: function disable() {
    return this.$img.cropper('disable');
  },

  reset: function reset() {
    return this.$img.cropper('reset');
  },

  clear: function clear() {
    return this.$img.cropper('clear');
  },

  replace: function replace(url) {
    return this.$img.cropper('replace', url);
  },

  destroy: function destroy() {
    return this.$img.cropper('destroy');
  },

  getData: function getData() {
    return this.$img.cropper('getData');
  },

  getContainerData: function getContainerData() {
    return this.$img.cropper('getContainerData');
  },

  getImageData: function getImageData() {
    return this.$img.cropper('getImageData');
  },

  getCanvasData: function getCanvasData() {
    return this.$img.cropper('getCanvasData');
  },

  setCanvasData: function setCanvasData(data) {
    return this.$img.cropper('setCanvasData', data);
  },

  getCropBoxData: function getCropBoxData() {
    return this.$img.cropper('getCropBoxData');
  },

  setCropBoxData: function setCropBoxData(data) {
    return this.$img.cropper('setCropBoxData', data);
  },

  getCroppedCanvas: function getCroppedCanvas(options) {
    return this.$img.cropper('getCroppedCanvas', options);
  },

  setAspectRatio: function setAspectRatio(aspectRatio) {
    return this.$img.cropper('setAspectRatio', aspectRatio);
  },

  setDragMode: function setDragMode() {
    return this.$img.cropper('setDragMode');
  },

  on: function on(eventname, callback) {
    return this.$img.on(eventname, callback);
  },

  render: function render() {
    return React.createElement(
      'div',
      this.props,
      React.createElement('img', {
        crossOrigin: 'anonymous',
        ref: 'img',
        src: this.props.src,
        alt: 'picture',
        style: { display: 'none' }
      })
    );
  }
});

module.exports = Cropper;