'use strict';

var _require = require('./utils');

var sort = _require.sort;
var filter = _require.filter;

var containsIgnoreCase = function containsIgnoreCase(a, b) {
  a = (a + '').toLowerCase().trim();
  b = (b + '').toLowerCase().trim();
  return b.indexOf(a) >= 0;
};

function buildInitialState(props) {
  return {
    // Clone the initialData.
    data: props.initialData.slice(0),
    sortBy: props.initialSortBy,
    filterValues: {},
    currentPage: 0,
    pageLength: props.initialPageLength
  };
}

module.exports = {

  getInitialState: function getInitialState() {
    return buildInitialState(this.props);
  },

  getDefaultProps: function getDefaultProps() {
    return {
      initialPageLength: 10,
      pageLengthOptions: [5, 10, 20],
      filters: {
        globalSearch: {
          filter: containsIgnoreCase
        }
      }
    };
  },

  componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
    this.setState(buildInitialState(nextProps));
  },

  componentWillMount: function componentWillMount() {
    // Do the initial sorting if specified.
    var _state = this.state;
    var sortBy = _state.sortBy;
    var data = _state.data;

    if (sortBy) {
      this.setState({ data: sort(sortBy, data) });
    }
  },

  onSort: function onSort(sortBy) {
    this.setState({
      sortBy: sortBy,
      data: sort(sortBy, this.state.data)
    });
  },

  onFilter: function onFilter(filterName, filterValue) {
    var _state2 = this.state;
    var filterValues = _state2.filterValues;
    var sortBy = _state2.sortBy;
    var _props = this.props;
    var initialData = _props.initialData;
    var filters = _props.filters;

    filterValues[filterName] = filterValue;
    var newData = filter(filters, filterValues, initialData);
    newData = sort(sortBy, newData);

    this.setState({
      data: newData,
      filterValues: filterValues,
      currentPage: 0
    });
  },

  // Pagination
  buildPage: function buildPage() {
    var _state3 = this.state;
    var data = _state3.data;
    var currentPage = _state3.currentPage;
    var pageLength = _state3.pageLength;

    var start = pageLength * currentPage;

    return {
      data: data.slice(start, start + pageLength),
      currentPage: currentPage,
      totalPages: Math.ceil(data.length / pageLength)
    };
  },

  onChangePage: function onChangePage(pageNumber) {
    this.setState({ currentPage: pageNumber });
  },

  onPageLengthChange: function onPageLengthChange(value) {
    var newPageLength = +value;
    var _state4 = this.state;
    var currentPage = _state4.currentPage;
    var pageLength = _state4.pageLength;

    var newPage = Math.floor(currentPage * pageLength / newPageLength);

    this.setState({
      pageLength: newPageLength,
      currentPage: newPage
    });
  }

};