import React from 'react';
import makeEventProps from 'make-event-props';
import Calendar from 'react-calendar';
import type { ReactNodeArray } from 'prop-types';
import type { ClassName, CloseReason, Detail, LooseValue, OpenReason, Value } from './shared/types.js';
type Icon = React.ReactElement | ReactNodeArray | null | string | number | boolean;
type IconOrRenderFunction = Icon | React.ComponentType | React.ReactElement;
type CalendarProps = Omit<React.ComponentPropsWithoutRef<typeof Calendar>, 'className' | 'maxDetail' | 'onChange'>;
type EventProps = ReturnType<typeof makeEventProps>;
export type DatePickerProps = {
    autoFocus?: boolean;
    calendarAriaLabel?: string;
    calendarClassName?: ClassName;
    calendarIcon?: IconOrRenderFunction | null;
    className?: ClassName;
    clearAriaLabel?: string;
    clearIcon?: IconOrRenderFunction | null;
    closeCalendar?: boolean;
    'data-testid'?: string;
    dayAriaLabel?: string;
    dayPlaceholder?: string;
    disableCalendar?: boolean;
    disabled?: boolean;
    format?: string;
    id?: string;
    isOpen?: boolean;
    locale?: string;
    maxDate?: Date;
    maxDetail?: Detail;
    minDate?: Date;
    monthAriaLabel?: string;
    monthPlaceholder?: string;
    name?: string;
    nativeInputAriaLabel?: string;
    onCalendarClose?: () => void;
    onCalendarOpen?: () => void;
    onChange?: (value: Value) => void;
    onFocus?: (event: React.FocusEvent<HTMLDivElement>) => void;
    onInvalidChange?: () => void;
    openCalendarOnFocus?: boolean;
    portalContainer?: HTMLElement | null;
    required?: boolean;
    returnValue?: 'start' | 'end' | 'range';
    shouldCloseCalendar?: (props: {
        reason: CloseReason;
    }) => boolean;
    shouldOpenCalendar?: (props: {
        reason: OpenReason;
    }) => boolean;
    showLeadingZeros?: boolean;
    value?: LooseValue;
    yearAriaLabel?: string;
    yearPlaceholder?: string;
} & CalendarProps & Omit<EventProps, 'onChange' | 'onFocus'>;
declare const DatePicker: React.FC<DatePickerProps>;
export default DatePicker;
