import shallowCompare from "react-addons-shallow-compare";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function () { function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); } return _getPrototypeOf; }(); return _getPrototypeOf(o); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function () { function _setPrototypeOf(o, p) { o.__proto__ = p; return o; } return _setPrototypeOf; }(); return _setPrototypeOf(o, p); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import React from 'react';
import PropTypes from 'prop-types';
import { forbidExtraProps, nonNegativeInteger } from 'airbnb-prop-types';
import { css, withStyles, withStylesPropTypes } from 'react-with-styles';
import throttle from 'lodash/throttle';
import isTouchDevice from 'is-touch-device';
import getInputHeight from '../utils/getInputHeight';
import openDirectionShape from '../shapes/OpenDirectionShape';
import { OPEN_DOWN, OPEN_UP, FANG_HEIGHT_PX, FANG_WIDTH_PX, DEFAULT_VERTICAL_SPACING, MODIFIER_KEY_NAMES } from '../constants';
var FANG_PATH_TOP = "M0,".concat(FANG_HEIGHT_PX, " ").concat(FANG_WIDTH_PX, ",").concat(FANG_HEIGHT_PX, " ").concat(FANG_WIDTH_PX / 2, ",0z");
var FANG_STROKE_TOP = "M0,".concat(FANG_HEIGHT_PX, " ").concat(FANG_WIDTH_PX / 2, ",0 ").concat(FANG_WIDTH_PX, ",").concat(FANG_HEIGHT_PX);
var FANG_PATH_BOTTOM = "M0,0 ".concat(FANG_WIDTH_PX, ",0 ").concat(FANG_WIDTH_PX / 2, ",").concat(FANG_HEIGHT_PX, "z");
var FANG_STROKE_BOTTOM = "M0,0 ".concat(FANG_WIDTH_PX / 2, ",").concat(FANG_HEIGHT_PX, " ").concat(FANG_WIDTH_PX, ",0");
var propTypes = process.env.NODE_ENV !== "production" ? forbidExtraProps(_objectSpread({}, withStylesPropTypes, {
  id: PropTypes.string.isRequired,
  placeholder: PropTypes.string,
  // also used as label
  displayValue: PropTypes.string,
  screenReaderMessage: PropTypes.string,
  focused: PropTypes.bool,
  disabled: PropTypes.bool,
  required: PropTypes.bool,
  readOnly: PropTypes.bool,
  openDirection: openDirectionShape,
  showCaret: PropTypes.bool,
  verticalSpacing: nonNegativeInteger,
  small: PropTypes.bool,
  block: PropTypes.bool,
  regular: PropTypes.bool,
  onChange: PropTypes.func,
  onFocus: PropTypes.func,
  onKeyDownShiftTab: PropTypes.func,
  onKeyDownTab: PropTypes.func,
  onKeyDownArrowDown: PropTypes.func,
  onKeyDownQuestionMark: PropTypes.func,
  // accessibility
  isFocused: PropTypes.bool // describes actual DOM focus

})) : {};
var defaultProps = {
  placeholder: 'Select Date',
  displayValue: '',
  screenReaderMessage: '',
  focused: false,
  disabled: false,
  required: false,
  readOnly: null,
  openDirection: OPEN_DOWN,
  showCaret: false,
  verticalSpacing: DEFAULT_VERTICAL_SPACING,
  small: false,
  block: false,
  regular: false,
  onChange: function () {
    function onChange() {}

    return onChange;
  }(),
  onFocus: function () {
    function onFocus() {}

    return onFocus;
  }(),
  onKeyDownShiftTab: function () {
    function onKeyDownShiftTab() {}

    return onKeyDownShiftTab;
  }(),
  onKeyDownTab: function () {
    function onKeyDownTab() {}

    return onKeyDownTab;
  }(),
  onKeyDownArrowDown: function () {
    function onKeyDownArrowDown() {}

    return onKeyDownArrowDown;
  }(),
  onKeyDownQuestionMark: function () {
    function onKeyDownQuestionMark() {}

    return onKeyDownQuestionMark;
  }(),
  // accessibility
  isFocused: false
};

var DateInput =
/*#__PURE__*/
function (_ref) {
  _inherits(DateInput, _ref);

  _createClass(DateInput, [{
    key: !React.PureComponent && "shouldComponentUpdate",
    value: function () {
      function value(nextProps, nextState) {
        return shallowCompare(this, nextProps, nextState);
      }

      return value;
    }()
  }]);

  function DateInput(props) {
    var _this;

    _classCallCheck(this, DateInput);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DateInput).call(this, props));
    _this.state = {
      dateString: '',
      isTouchDevice: false
    };
    _this.onChange = _this.onChange.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.setInputRef = _this.setInputRef.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.throttledKeyDown = throttle(_this.onFinalKeyDown, 300, {
      trailing: false
    });
    return _this;
  }

  _createClass(DateInput, [{
    key: "componentDidMount",
    value: function () {
      function componentDidMount() {
        this.setState({
          isTouchDevice: isTouchDevice()
        });
      }

      return componentDidMount;
    }()
  }, {
    key: "componentWillReceiveProps",
    value: function () {
      function componentWillReceiveProps(nextProps) {
        var dateString = this.state.dateString;

        if (dateString && nextProps.displayValue) {
          this.setState({
            dateString: ''
          });
        }
      }

      return componentWillReceiveProps;
    }()
  }, {
    key: "componentDidUpdate",
    value: function () {
      function componentDidUpdate(prevProps) {
        var _this$props = this.props,
            focused = _this$props.focused,
            isFocused = _this$props.isFocused;
        if (prevProps.focused === focused && prevProps.isFocused === isFocused) return;

        if (focused && isFocused) {
          this.inputRef.focus();
        }
      }

      return componentDidUpdate;
    }()
  }, {
    key: "onChange",
    value: function () {
      function onChange(e) {
        var _this$props2 = this.props,
            onChange = _this$props2.onChange,
            onKeyDownQuestionMark = _this$props2.onKeyDownQuestionMark;
        var dateString = e.target.value; // In Safari, onKeyDown does not consistently fire ahead of onChange. As a result, we need to
        // special case the `?` key so that it always triggers the appropriate callback, instead of
        // modifying the input value

        if (dateString[dateString.length - 1] === '?') {
          onKeyDownQuestionMark(e);
        } else {
          this.setState({
            dateString: dateString
          }, function () {
            return onChange(dateString);
          });
        }
      }

      return onChange;
    }()
  }, {
    key: "onKeyDown",
    value: function () {
      function onKeyDown(e) {
        e.stopPropagation();

        if (!MODIFIER_KEY_NAMES.has(e.key)) {
          this.throttledKeyDown(e);
        }
      }

      return onKeyDown;
    }()
  }, {
    key: "onFinalKeyDown",
    value: function () {
      function onFinalKeyDown(e) {
        var _this$props3 = this.props,
            onKeyDownShiftTab = _this$props3.onKeyDownShiftTab,
            onKeyDownTab = _this$props3.onKeyDownTab,
            onKeyDownArrowDown = _this$props3.onKeyDownArrowDown,
            onKeyDownQuestionMark = _this$props3.onKeyDownQuestionMark;
        var key = e.key;

        if (key === 'Tab') {
          if (e.shiftKey) {
            onKeyDownShiftTab(e);
          } else {
            onKeyDownTab(e);
          }
        } else if (key === 'ArrowDown') {
          onKeyDownArrowDown(e);
        } else if (key === '?') {
          e.preventDefault();
          onKeyDownQuestionMark(e);
        }
      }

      return onFinalKeyDown;
    }()
  }, {
    key: "setInputRef",
    value: function () {
      function setInputRef(ref) {
        this.inputRef = ref;
      }

      return setInputRef;
    }()
  }, {
    key: "render",
    value: function () {
      function render() {
        var _this$state = this.state,
            dateString = _this$state.dateString,
            isTouch = _this$state.isTouchDevice;
        var _this$props4 = this.props,
            id = _this$props4.id,
            placeholder = _this$props4.placeholder,
            displayValue = _this$props4.displayValue,
            screenReaderMessage = _this$props4.screenReaderMessage,
            focused = _this$props4.focused,
            showCaret = _this$props4.showCaret,
            onFocus = _this$props4.onFocus,
            disabled = _this$props4.disabled,
            required = _this$props4.required,
            readOnly = _this$props4.readOnly,
            openDirection = _this$props4.openDirection,
            verticalSpacing = _this$props4.verticalSpacing,
            small = _this$props4.small,
            regular = _this$props4.regular,
            block = _this$props4.block,
            styles = _this$props4.styles,
            reactDates = _this$props4.theme.reactDates;
        var value = dateString || displayValue || '';
        var screenReaderMessageId = "DateInput__screen-reader-message-".concat(id);
        var withFang = showCaret && focused;
        var inputHeight = getInputHeight(reactDates, small);
        return React.createElement("div", css(styles.DateInput, small && styles.DateInput__small, block && styles.DateInput__block, withFang && styles.DateInput__withFang, disabled && styles.DateInput__disabled, withFang && openDirection === OPEN_DOWN && styles.DateInput__openDown, withFang && openDirection === OPEN_UP && styles.DateInput__openUp), React.createElement("input", _extends({}, css(styles.DateInput_input, small && styles.DateInput_input__small, regular && styles.DateInput_input__regular, readOnly && styles.DateInput_input__readOnly, focused && styles.DateInput_input__focused, disabled && styles.DateInput_input__disabled), {
          "aria-label": placeholder,
          type: "text",
          id: id,
          name: id,
          ref: this.setInputRef,
          value: value,
          onChange: this.onChange,
          onKeyDown: this.onKeyDown,
          onFocus: onFocus,
          placeholder: placeholder,
          autoComplete: "off",
          disabled: disabled,
          readOnly: typeof readOnly === 'boolean' ? readOnly : isTouch,
          required: required,
          "aria-describedby": screenReaderMessage && screenReaderMessageId
        })), withFang && React.createElement("svg", _extends({
          role: "presentation",
          focusable: "false"
        }, css(styles.DateInput_fang, openDirection === OPEN_DOWN && {
          top: inputHeight + verticalSpacing - FANG_HEIGHT_PX - 1
        }, openDirection === OPEN_UP && {
          bottom: inputHeight + verticalSpacing - FANG_HEIGHT_PX - 1
        })), React.createElement("path", _extends({}, css(styles.DateInput_fangShape), {
          d: openDirection === OPEN_DOWN ? FANG_PATH_TOP : FANG_PATH_BOTTOM
        })), React.createElement("path", _extends({}, css(styles.DateInput_fangStroke), {
          d: openDirection === OPEN_DOWN ? FANG_STROKE_TOP : FANG_STROKE_BOTTOM
        }))), screenReaderMessage && React.createElement("p", _extends({}, css(styles.DateInput_screenReaderMessage), {
          id: screenReaderMessageId
        }), screenReaderMessage));
      }

      return render;
    }()
  }]);

  return DateInput;
}(React.PureComponent || React.Component);

DateInput.propTypes = process.env.NODE_ENV !== "production" ? propTypes : {};
DateInput.defaultProps = defaultProps;
export default withStyles(function (_ref2) {
  var _ref2$reactDates = _ref2.reactDates,
      border = _ref2$reactDates.border,
      color = _ref2$reactDates.color,
      sizing = _ref2$reactDates.sizing,
      spacing = _ref2$reactDates.spacing,
      font = _ref2$reactDates.font,
      zIndex = _ref2$reactDates.zIndex;
  return {
    DateInput: {
      margin: 0,
      padding: spacing.inputPadding,
      background: color.background,
      position: 'relative',
      display: 'inline-block',
      width: sizing.inputWidth,
      verticalAlign: 'middle'
    },
    DateInput__small: {
      width: sizing.inputWidth_small
    },
    DateInput__block: {
      width: '100%'
    },
    DateInput__disabled: {
      background: color.disabled,
      color: color.textDisabled
    },
    DateInput_input: {
      fontWeight: 200,
      fontSize: font.input.size,
      lineHeight: font.input.lineHeight,
      color: color.text,
      backgroundColor: color.background,
      width: '100%',
      padding: "".concat(spacing.displayTextPaddingVertical, "px ").concat(spacing.displayTextPaddingHorizontal, "px"),
      paddingTop: spacing.displayTextPaddingTop,
      paddingBottom: spacing.displayTextPaddingBottom,
      paddingLeft: spacing.displayTextPaddingLeft,
      paddingRight: spacing.displayTextPaddingRight,
      border: border.input.border,
      borderTop: border.input.borderTop,
      borderRight: border.input.borderRight,
      borderBottom: border.input.borderBottom,
      borderLeft: border.input.borderLeft,
      borderRadius: border.input.borderRadius
    },
    DateInput_input__small: {
      fontSize: font.input.size_small,
      lineHeight: font.input.lineHeight_small,
      letterSpacing: font.input.letterSpacing_small,
      padding: "".concat(spacing.displayTextPaddingVertical_small, "px ").concat(spacing.displayTextPaddingHorizontal_small, "px"),
      paddingTop: spacing.displayTextPaddingTop_small,
      paddingBottom: spacing.displayTextPaddingBottom_small,
      paddingLeft: spacing.displayTextPaddingLeft_small,
      paddingRight: spacing.displayTextPaddingRight_small
    },
    DateInput_input__regular: {
      fontWeight: 'auto'
    },
    DateInput_input__readOnly: {
      userSelect: 'none'
    },
    DateInput_input__focused: {
      outline: border.input.outlineFocused,
      background: color.backgroundFocused,
      border: border.input.borderFocused,
      borderTop: border.input.borderTopFocused,
      borderRight: border.input.borderRightFocused,
      borderBottom: border.input.borderBottomFocused,
      borderLeft: border.input.borderLeftFocused
    },
    DateInput_input__disabled: {
      background: color.disabled,
      fontStyle: font.input.styleDisabled
    },
    DateInput_screenReaderMessage: {
      border: 0,
      clip: 'rect(0, 0, 0, 0)',
      height: 1,
      margin: -1,
      overflow: 'hidden',
      padding: 0,
      position: 'absolute',
      width: 1
    },
    DateInput_fang: {
      position: 'absolute',
      width: FANG_WIDTH_PX,
      height: FANG_HEIGHT_PX,
      left: 22,
      zIndex: zIndex + 2
    },
    DateInput_fangShape: {
      fill: color.background
    },
    DateInput_fangStroke: {
      stroke: color.core.border,
      fill: 'transparent'
    }
  };
}, {
  pureComponent: typeof React.PureComponent !== 'undefined'
})(DateInput);