"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactAddonsShallowCompare = _interopRequireDefault(require("react-addons-shallow-compare"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactMomentProptypes = _interopRequireDefault(require("react-moment-proptypes"));

var _airbnbPropTypes = require("airbnb-prop-types");

var _moment = _interopRequireDefault(require("moment"));

var _object = _interopRequireDefault(require("object.values"));

var _isTouchDevice = _interopRequireDefault(require("is-touch-device"));

var _defaultPhrases = require("../defaultPhrases");

var _getPhrasePropTypes = _interopRequireDefault(require("../utils/getPhrasePropTypes"));

var _isInclusivelyAfterDay = _interopRequireDefault(require("../utils/isInclusivelyAfterDay"));

var _isNextDay = _interopRequireDefault(require("../utils/isNextDay"));

var _isSameDay = _interopRequireDefault(require("../utils/isSameDay"));

var _isAfterDay = _interopRequireDefault(require("../utils/isAfterDay"));

var _isBeforeDay = _interopRequireDefault(require("../utils/isBeforeDay"));

var _getVisibleDays = _interopRequireDefault(require("../utils/getVisibleDays"));

var _isDayVisible = _interopRequireDefault(require("../utils/isDayVisible"));

var _getSelectedDateOffset = _interopRequireDefault(require("../utils/getSelectedDateOffset"));

var _toISODateString = _interopRequireDefault(require("../utils/toISODateString"));

var _toISOMonthString = _interopRequireDefault(require("../utils/toISOMonthString"));

var _DisabledShape = _interopRequireDefault(require("../shapes/DisabledShape"));

var _FocusedInputShape = _interopRequireDefault(require("../shapes/FocusedInputShape"));

var _ScrollableOrientationShape = _interopRequireDefault(require("../shapes/ScrollableOrientationShape"));

var _DayOfWeekShape = _interopRequireDefault(require("../shapes/DayOfWeekShape"));

var _CalendarInfoPositionShape = _interopRequireDefault(require("../shapes/CalendarInfoPositionShape"));

var _constants = require("../constants");

var _DayPicker = _interopRequireDefault(require("./DayPicker"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function () { function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); } return _getPrototypeOf; }(); return _getPrototypeOf(o); }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function () { function _setPrototypeOf(o, p) { o.__proto__ = p; return o; } return _setPrototypeOf; }(); return _setPrototypeOf(o, p); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

var propTypes = process.env.NODE_ENV !== "production" ? (0, _airbnbPropTypes.forbidExtraProps)({
  startDate: _reactMomentProptypes["default"].momentObj,
  endDate: _reactMomentProptypes["default"].momentObj,
  onDatesChange: _propTypes["default"].func,
  startDateOffset: _propTypes["default"].func,
  endDateOffset: _propTypes["default"].func,
  focusedInput: _FocusedInputShape["default"],
  onFocusChange: _propTypes["default"].func,
  onClose: _propTypes["default"].func,
  keepOpenOnDateSelect: _propTypes["default"].bool,
  minimumNights: _propTypes["default"].number,
  disabled: _DisabledShape["default"],
  isOutsideRange: _propTypes["default"].func,
  isDayBlocked: _propTypes["default"].func,
  isDayHighlighted: _propTypes["default"].func,
  // DayPicker props
  renderMonthText: (0, _airbnbPropTypes.mutuallyExclusiveProps)(_propTypes["default"].func, 'renderMonthText', 'renderMonthElement'),
  renderMonthElement: (0, _airbnbPropTypes.mutuallyExclusiveProps)(_propTypes["default"].func, 'renderMonthText', 'renderMonthElement'),
  enableOutsideDays: _propTypes["default"].bool,
  numberOfMonths: _propTypes["default"].number,
  orientation: _ScrollableOrientationShape["default"],
  withPortal: _propTypes["default"].bool,
  initialVisibleMonth: _propTypes["default"].func,
  hideKeyboardShortcutsPanel: _propTypes["default"].bool,
  daySize: _airbnbPropTypes.nonNegativeInteger,
  noBorder: _propTypes["default"].bool,
  verticalBorderSpacing: _airbnbPropTypes.nonNegativeInteger,
  horizontalMonthPadding: _airbnbPropTypes.nonNegativeInteger,
  navPrev: _propTypes["default"].node,
  navNext: _propTypes["default"].node,
  noNavButtons: _propTypes["default"].bool,
  onPrevMonthClick: _propTypes["default"].func,
  onNextMonthClick: _propTypes["default"].func,
  onOutsideClick: _propTypes["default"].func,
  renderCalendarDay: _propTypes["default"].func,
  renderDayContents: _propTypes["default"].func,
  renderCalendarInfo: _propTypes["default"].func,
  calendarInfoPosition: _CalendarInfoPositionShape["default"],
  firstDayOfWeek: _DayOfWeekShape["default"],
  verticalHeight: _airbnbPropTypes.nonNegativeInteger,
  transitionDuration: _airbnbPropTypes.nonNegativeInteger,
  // accessibility
  onBlur: _propTypes["default"].func,
  isFocused: _propTypes["default"].bool,
  showKeyboardShortcuts: _propTypes["default"].bool,
  onTab: _propTypes["default"].func,
  onShiftTab: _propTypes["default"].func,
  // i18n
  monthFormat: _propTypes["default"].string,
  weekDayFormat: _propTypes["default"].string,
  phrases: _propTypes["default"].shape((0, _getPhrasePropTypes["default"])(_defaultPhrases.DayPickerPhrases)),
  dayAriaLabelFormat: _propTypes["default"].string,
  isRTL: _propTypes["default"].bool
}) : {};
var defaultProps = {
  startDate: undefined,
  // TODO: use null
  endDate: undefined,
  // TODO: use null
  onDatesChange: function () {
    function onDatesChange() {}

    return onDatesChange;
  }(),
  startDateOffset: undefined,
  endDateOffset: undefined,
  focusedInput: null,
  onFocusChange: function () {
    function onFocusChange() {}

    return onFocusChange;
  }(),
  onClose: function () {
    function onClose() {}

    return onClose;
  }(),
  keepOpenOnDateSelect: false,
  minimumNights: 1,
  disabled: false,
  isOutsideRange: function () {
    function isOutsideRange() {}

    return isOutsideRange;
  }(),
  isDayBlocked: function () {
    function isDayBlocked() {}

    return isDayBlocked;
  }(),
  isDayHighlighted: function () {
    function isDayHighlighted() {}

    return isDayHighlighted;
  }(),
  // DayPicker props
  renderMonthText: null,
  enableOutsideDays: false,
  numberOfMonths: 1,
  orientation: _constants.HORIZONTAL_ORIENTATION,
  withPortal: false,
  hideKeyboardShortcutsPanel: false,
  initialVisibleMonth: null,
  daySize: _constants.DAY_SIZE,
  navPrev: null,
  navNext: null,
  noNavButtons: false,
  onPrevMonthClick: function () {
    function onPrevMonthClick() {}

    return onPrevMonthClick;
  }(),
  onNextMonthClick: function () {
    function onNextMonthClick() {}

    return onNextMonthClick;
  }(),
  onOutsideClick: function () {
    function onOutsideClick() {}

    return onOutsideClick;
  }(),
  renderCalendarDay: undefined,
  renderDayContents: null,
  renderCalendarInfo: null,
  renderMonthElement: null,
  calendarInfoPosition: _constants.INFO_POSITION_BOTTOM,
  firstDayOfWeek: null,
  verticalHeight: null,
  noBorder: false,
  transitionDuration: undefined,
  verticalBorderSpacing: undefined,
  horizontalMonthPadding: 13,
  // accessibility
  onBlur: function () {
    function onBlur() {}

    return onBlur;
  }(),
  isFocused: false,
  showKeyboardShortcuts: false,
  onTab: function () {
    function onTab() {}

    return onTab;
  }(),
  onShiftTab: function () {
    function onShiftTab() {}

    return onShiftTab;
  }(),
  // i18n
  monthFormat: 'MMMM YYYY',
  weekDayFormat: 'dd',
  phrases: _defaultPhrases.DayPickerPhrases,
  dayAriaLabelFormat: undefined,
  isRTL: false
};

var getChooseAvailableDatePhrase = function getChooseAvailableDatePhrase(phrases, focusedInput) {
  if (focusedInput === _constants.START_DATE) {
    return phrases.chooseAvailableStartDate;
  }

  if (focusedInput === _constants.END_DATE) {
    return phrases.chooseAvailableEndDate;
  }

  return phrases.chooseAvailableDate;
};

var DayPickerRangeController =
/*#__PURE__*/
function (_ref) {
  _inherits(DayPickerRangeController, _ref);

  _createClass(DayPickerRangeController, [{
    key: !_react["default"].PureComponent && "shouldComponentUpdate",
    value: function () {
      function value(nextProps, nextState) {
        return (0, _reactAddonsShallowCompare["default"])(this, nextProps, nextState);
      }

      return value;
    }()
  }]);

  function DayPickerRangeController(props) {
    var _this;

    _classCallCheck(this, DayPickerRangeController);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(DayPickerRangeController).call(this, props));
    _this.isTouchDevice = (0, _isTouchDevice["default"])();
    _this.today = (0, _moment["default"])();
    _this.modifiers = {
      today: function () {
        function today(day) {
          return _this.isToday(day);
        }

        return today;
      }(),
      blocked: function () {
        function blocked(day) {
          return _this.isBlocked(day);
        }

        return blocked;
      }(),
      'blocked-calendar': function () {
        function blockedCalendar(day) {
          return props.isDayBlocked(day);
        }

        return blockedCalendar;
      }(),
      'blocked-out-of-range': function () {
        function blockedOutOfRange(day) {
          return props.isOutsideRange(day);
        }

        return blockedOutOfRange;
      }(),
      'highlighted-calendar': function () {
        function highlightedCalendar(day) {
          return props.isDayHighlighted(day);
        }

        return highlightedCalendar;
      }(),
      valid: function () {
        function valid(day) {
          return !_this.isBlocked(day);
        }

        return valid;
      }(),
      'selected-start': function () {
        function selectedStart(day) {
          return _this.isStartDate(day);
        }

        return selectedStart;
      }(),
      'selected-end': function () {
        function selectedEnd(day) {
          return _this.isEndDate(day);
        }

        return selectedEnd;
      }(),
      'blocked-minimum-nights': function () {
        function blockedMinimumNights(day) {
          return _this.doesNotMeetMinimumNights(day);
        }

        return blockedMinimumNights;
      }(),
      'selected-span': function () {
        function selectedSpan(day) {
          return _this.isInSelectedSpan(day);
        }

        return selectedSpan;
      }(),
      'last-in-range': function () {
        function lastInRange(day) {
          return _this.isLastInRange(day);
        }

        return lastInRange;
      }(),
      hovered: function () {
        function hovered(day) {
          return _this.isHovered(day);
        }

        return hovered;
      }(),
      'hovered-span': function () {
        function hoveredSpan(day) {
          return _this.isInHoveredSpan(day);
        }

        return hoveredSpan;
      }(),
      'hovered-offset': function () {
        function hoveredOffset(day) {
          return _this.isInHoveredSpan(day);
        }

        return hoveredOffset;
      }(),
      'after-hovered-start': function () {
        function afterHoveredStart(day) {
          return _this.isDayAfterHoveredStartDate(day);
        }

        return afterHoveredStart;
      }(),
      'first-day-of-week': function () {
        function firstDayOfWeek(day) {
          return _this.isFirstDayOfWeek(day);
        }

        return firstDayOfWeek;
      }(),
      'last-day-of-week': function () {
        function lastDayOfWeek(day) {
          return _this.isLastDayOfWeek(day);
        }

        return lastDayOfWeek;
      }()
    };

    var _this$getStateForNewM = _this.getStateForNewMonth(props),
        currentMonth = _this$getStateForNewM.currentMonth,
        visibleDays = _this$getStateForNewM.visibleDays; // initialize phrases
    // set the appropriate CalendarDay phrase based on focusedInput


    var chooseAvailableDate = getChooseAvailableDatePhrase(props.phrases, props.focusedInput);
    _this.state = {
      hoverDate: null,
      currentMonth: currentMonth,
      phrases: _objectSpread({}, props.phrases, {
        chooseAvailableDate: chooseAvailableDate
      }),
      visibleDays: visibleDays
    };
    _this.onDayClick = _this.onDayClick.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.onDayMouseEnter = _this.onDayMouseEnter.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.onDayMouseLeave = _this.onDayMouseLeave.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.onPrevMonthClick = _this.onPrevMonthClick.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.onNextMonthClick = _this.onNextMonthClick.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.onMonthChange = _this.onMonthChange.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.onYearChange = _this.onYearChange.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.onMultiplyScrollableMonths = _this.onMultiplyScrollableMonths.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    _this.getFirstFocusableDay = _this.getFirstFocusableDay.bind(_assertThisInitialized(_assertThisInitialized(_this)));
    return _this;
  }

  _createClass(DayPickerRangeController, [{
    key: "componentWillReceiveProps",
    value: function () {
      function componentWillReceiveProps(nextProps) {
        var _this2 = this;

        var startDate = nextProps.startDate,
            endDate = nextProps.endDate,
            focusedInput = nextProps.focusedInput,
            minimumNights = nextProps.minimumNights,
            isOutsideRange = nextProps.isOutsideRange,
            isDayBlocked = nextProps.isDayBlocked,
            isDayHighlighted = nextProps.isDayHighlighted,
            phrases = nextProps.phrases,
            initialVisibleMonth = nextProps.initialVisibleMonth,
            numberOfMonths = nextProps.numberOfMonths,
            enableOutsideDays = nextProps.enableOutsideDays;
        var _this$props = this.props,
            prevStartDate = _this$props.startDate,
            prevEndDate = _this$props.endDate,
            prevFocusedInput = _this$props.focusedInput,
            prevMinimumNights = _this$props.minimumNights,
            prevIsOutsideRange = _this$props.isOutsideRange,
            prevIsDayBlocked = _this$props.isDayBlocked,
            prevIsDayHighlighted = _this$props.isDayHighlighted,
            prevPhrases = _this$props.phrases,
            prevInitialVisibleMonth = _this$props.initialVisibleMonth,
            prevNumberOfMonths = _this$props.numberOfMonths,
            prevEnableOutsideDays = _this$props.enableOutsideDays;
        var visibleDays = this.state.visibleDays;
        var recomputeOutsideRange = false;
        var recomputeDayBlocked = false;
        var recomputeDayHighlighted = false;

        if (isOutsideRange !== prevIsOutsideRange) {
          this.modifiers['blocked-out-of-range'] = function (day) {
            return isOutsideRange(day);
          };

          recomputeOutsideRange = true;
        }

        if (isDayBlocked !== prevIsDayBlocked) {
          this.modifiers['blocked-calendar'] = function (day) {
            return isDayBlocked(day);
          };

          recomputeDayBlocked = true;
        }

        if (isDayHighlighted !== prevIsDayHighlighted) {
          this.modifiers['highlighted-calendar'] = function (day) {
            return isDayHighlighted(day);
          };

          recomputeDayHighlighted = true;
        }

        var recomputePropModifiers = recomputeOutsideRange || recomputeDayBlocked || recomputeDayHighlighted;
        var didStartDateChange = startDate !== prevStartDate;
        var didEndDateChange = endDate !== prevEndDate;
        var didFocusChange = focusedInput !== prevFocusedInput;

        if (numberOfMonths !== prevNumberOfMonths || enableOutsideDays !== prevEnableOutsideDays || initialVisibleMonth !== prevInitialVisibleMonth && !prevFocusedInput && didFocusChange) {
          var newMonthState = this.getStateForNewMonth(nextProps);
          var currentMonth = newMonthState.currentMonth;
          visibleDays = newMonthState.visibleDays;
          this.setState({
            currentMonth: currentMonth,
            visibleDays: visibleDays
          });
        }

        var modifiers = {};

        if (didStartDateChange) {
          modifiers = this.deleteModifier(modifiers, prevStartDate, 'selected-start');
          modifiers = this.addModifier(modifiers, startDate, 'selected-start');

          if (prevStartDate) {
            var startSpan = prevStartDate.clone().add(1, 'day');
            var endSpan = prevStartDate.clone().add(prevMinimumNights + 1, 'days');
            modifiers = this.deleteModifierFromRange(modifiers, startSpan, endSpan, 'after-hovered-start');
          }
        }

        if (didEndDateChange) {
          modifiers = this.deleteModifier(modifiers, prevEndDate, 'selected-end');
          modifiers = this.addModifier(modifiers, endDate, 'selected-end');
        }

        if (didStartDateChange || didEndDateChange) {
          if (prevStartDate && prevEndDate) {
            modifiers = this.deleteModifierFromRange(modifiers, prevStartDate, prevEndDate.clone().add(1, 'day'), 'selected-span');
          }

          if (startDate && endDate) {
            modifiers = this.deleteModifierFromRange(modifiers, startDate, endDate.clone().add(1, 'day'), 'hovered-span');
            modifiers = this.addModifierToRange(modifiers, startDate.clone().add(1, 'day'), endDate, 'selected-span');
          }
        }

        if (!this.isTouchDevice && didStartDateChange && startDate && !endDate) {
          var _startSpan = startDate.clone().add(1, 'day');

          var _endSpan = startDate.clone().add(minimumNights + 1, 'days');

          modifiers = this.addModifierToRange(modifiers, _startSpan, _endSpan, 'after-hovered-start');
        }

        if (prevMinimumNights > 0) {
          if (didFocusChange || didStartDateChange || minimumNights !== prevMinimumNights) {
            var _startSpan2 = prevStartDate || this.today;

            modifiers = this.deleteModifierFromRange(modifiers, _startSpan2, _startSpan2.clone().add(prevMinimumNights, 'days'), 'blocked-minimum-nights');
            modifiers = this.deleteModifierFromRange(modifiers, _startSpan2, _startSpan2.clone().add(prevMinimumNights, 'days'), 'blocked');
          }
        }

        if (didFocusChange || recomputePropModifiers) {
          (0, _object["default"])(visibleDays).forEach(function (days) {
            Object.keys(days).forEach(function (day) {
              var momentObj = (0, _moment["default"])(day);
              var isBlocked = false;

              if (didFocusChange || recomputeOutsideRange) {
                if (isOutsideRange(momentObj)) {
                  modifiers = _this2.addModifier(modifiers, momentObj, 'blocked-out-of-range');
                  isBlocked = true;
                } else {
                  modifiers = _this2.deleteModifier(modifiers, momentObj, 'blocked-out-of-range');
                }
              }

              if (didFocusChange || recomputeDayBlocked) {
                if (isDayBlocked(momentObj)) {
                  modifiers = _this2.addModifier(modifiers, momentObj, 'blocked-calendar');
                  isBlocked = true;
                } else {
                  modifiers = _this2.deleteModifier(modifiers, momentObj, 'blocked-calendar');
                }
              }

              if (isBlocked) {
                modifiers = _this2.addModifier(modifiers, momentObj, 'blocked');
              } else {
                modifiers = _this2.deleteModifier(modifiers, momentObj, 'blocked');
              }

              if (didFocusChange || recomputeDayHighlighted) {
                if (isDayHighlighted(momentObj)) {
                  modifiers = _this2.addModifier(modifiers, momentObj, 'highlighted-calendar');
                } else {
                  modifiers = _this2.deleteModifier(modifiers, momentObj, 'highlighted-calendar');
                }
              }
            });
          });
        }

        if (minimumNights > 0 && startDate && focusedInput === _constants.END_DATE) {
          modifiers = this.addModifierToRange(modifiers, startDate, startDate.clone().add(minimumNights, 'days'), 'blocked-minimum-nights');
          modifiers = this.addModifierToRange(modifiers, startDate, startDate.clone().add(minimumNights, 'days'), 'blocked');
        }

        var today = (0, _moment["default"])();

        if (!(0, _isSameDay["default"])(this.today, today)) {
          modifiers = this.deleteModifier(modifiers, this.today, 'today');
          modifiers = this.addModifier(modifiers, today, 'today');
          this.today = today;
        }

        if (Object.keys(modifiers).length > 0) {
          this.setState({
            visibleDays: _objectSpread({}, visibleDays, modifiers)
          });
        }

        if (didFocusChange || phrases !== prevPhrases) {
          // set the appropriate CalendarDay phrase based on focusedInput
          var chooseAvailableDate = getChooseAvailableDatePhrase(phrases, focusedInput);
          this.setState({
            phrases: _objectSpread({}, phrases, {
              chooseAvailableDate: chooseAvailableDate
            })
          });
        }
      }

      return componentWillReceiveProps;
    }()
  }, {
    key: "onDayClick",
    value: function () {
      function onDayClick(day, e) {
        var _this$props2 = this.props,
            keepOpenOnDateSelect = _this$props2.keepOpenOnDateSelect,
            minimumNights = _this$props2.minimumNights,
            onBlur = _this$props2.onBlur,
            focusedInput = _this$props2.focusedInput,
            onFocusChange = _this$props2.onFocusChange,
            onClose = _this$props2.onClose,
            onDatesChange = _this$props2.onDatesChange,
            startDateOffset = _this$props2.startDateOffset,
            endDateOffset = _this$props2.endDateOffset,
            disabled = _this$props2.disabled;
        if (e) e.preventDefault();
        if (this.isBlocked(day)) return;
        var _this$props3 = this.props,
            startDate = _this$props3.startDate,
            endDate = _this$props3.endDate;

        if (startDateOffset || endDateOffset) {
          startDate = (0, _getSelectedDateOffset["default"])(startDateOffset, day);
          endDate = (0, _getSelectedDateOffset["default"])(endDateOffset, day);

          if (!keepOpenOnDateSelect) {
            onFocusChange(null);
            onClose({
              startDate: startDate,
              endDate: endDate
            });
          }
        } else if (focusedInput === _constants.START_DATE) {
          var lastAllowedStartDate = endDate && endDate.clone().subtract(minimumNights, 'days');
          var isStartDateAfterEndDate = (0, _isBeforeDay["default"])(lastAllowedStartDate, day) || (0, _isAfterDay["default"])(startDate, endDate);
          var isEndDateDisabled = disabled === _constants.END_DATE;

          if (!isEndDateDisabled || !isStartDateAfterEndDate) {
            startDate = day;

            if (isStartDateAfterEndDate) {
              endDate = null;
            }
          }

          if (isEndDateDisabled && !isStartDateAfterEndDate) {
            onFocusChange(null);
            onClose({
              startDate: startDate,
              endDate: endDate
            });
          } else if (!isEndDateDisabled) {
            onFocusChange(_constants.END_DATE);
          }
        } else if (focusedInput === _constants.END_DATE) {
          var firstAllowedEndDate = startDate && startDate.clone().add(minimumNights, 'days');

          if (!startDate) {
            endDate = day;
            onFocusChange(_constants.START_DATE);
          } else if ((0, _isInclusivelyAfterDay["default"])(day, firstAllowedEndDate)) {
            endDate = day;

            if (!keepOpenOnDateSelect) {
              onFocusChange(null);
              onClose({
                startDate: startDate,
                endDate: endDate
              });
            }
          } else if (disabled !== _constants.START_DATE) {
            startDate = day;
            endDate = null;
          }
        }

        onDatesChange({
          startDate: startDate,
          endDate: endDate
        });
        onBlur();
      }

      return onDayClick;
    }()
  }, {
    key: "onDayMouseEnter",
    value: function () {
      function onDayMouseEnter(day) {
        /* eslint react/destructuring-assignment: 1 */
        if (this.isTouchDevice) return;
        var _this$props4 = this.props,
            startDate = _this$props4.startDate,
            endDate = _this$props4.endDate,
            focusedInput = _this$props4.focusedInput,
            minimumNights = _this$props4.minimumNights,
            startDateOffset = _this$props4.startDateOffset,
            endDateOffset = _this$props4.endDateOffset;
        var _this$state = this.state,
            hoverDate = _this$state.hoverDate,
            visibleDays = _this$state.visibleDays;
        var dateOffset = null;

        if (focusedInput) {
          var hasOffset = startDateOffset || endDateOffset;
          var modifiers = {};

          if (hasOffset) {
            var start = (0, _getSelectedDateOffset["default"])(startDateOffset, day);
            var end = (0, _getSelectedDateOffset["default"])(endDateOffset, day, function (rangeDay) {
              return rangeDay.add(1, 'day');
            });
            dateOffset = {
              start: start,
              end: end
            }; // eslint-disable-next-line react/destructuring-assignment

            if (this.state.dateOffset && this.state.dateOffset.start && this.state.dateOffset.end) {
              modifiers = this.deleteModifierFromRange(modifiers, this.state.dateOffset.start, this.state.dateOffset.end, 'hovered-offset');
            }

            modifiers = this.addModifierToRange(modifiers, start, end, 'hovered-offset');
          }

          if (!hasOffset) {
            modifiers = this.deleteModifier(modifiers, hoverDate, 'hovered');
            modifiers = this.addModifier(modifiers, day, 'hovered');

            if (startDate && !endDate && focusedInput === _constants.END_DATE) {
              if ((0, _isAfterDay["default"])(hoverDate, startDate)) {
                var endSpan = hoverDate.clone().add(1, 'day');
                modifiers = this.deleteModifierFromRange(modifiers, startDate, endSpan, 'hovered-span');
              }

              if (!this.isBlocked(day) && (0, _isAfterDay["default"])(day, startDate)) {
                var _endSpan2 = day.clone().add(1, 'day');

                modifiers = this.addModifierToRange(modifiers, startDate, _endSpan2, 'hovered-span');
              }
            }

            if (!startDate && endDate && focusedInput === _constants.START_DATE) {
              if ((0, _isBeforeDay["default"])(hoverDate, endDate)) {
                modifiers = this.deleteModifierFromRange(modifiers, hoverDate, endDate, 'hovered-span');
              }

              if (!this.isBlocked(day) && (0, _isBeforeDay["default"])(day, endDate)) {
                modifiers = this.addModifierToRange(modifiers, day, endDate, 'hovered-span');
              }
            }

            if (startDate) {
              var startSpan = startDate.clone().add(1, 'day');

              var _endSpan3 = startDate.clone().add(minimumNights + 1, 'days');

              modifiers = this.deleteModifierFromRange(modifiers, startSpan, _endSpan3, 'after-hovered-start');

              if ((0, _isSameDay["default"])(day, startDate)) {
                var newStartSpan = startDate.clone().add(1, 'day');
                var newEndSpan = startDate.clone().add(minimumNights + 1, 'days');
                modifiers = this.addModifierToRange(modifiers, newStartSpan, newEndSpan, 'after-hovered-start');
              }
            }
          }

          this.setState({
            hoverDate: day,
            dateOffset: dateOffset,
            visibleDays: _objectSpread({}, visibleDays, modifiers)
          });
        }
      }

      return onDayMouseEnter;
    }()
  }, {
    key: "onDayMouseLeave",
    value: function () {
      function onDayMouseLeave(day) {
        var _this$props5 = this.props,
            startDate = _this$props5.startDate,
            endDate = _this$props5.endDate,
            minimumNights = _this$props5.minimumNights;
        var _this$state2 = this.state,
            hoverDate = _this$state2.hoverDate,
            visibleDays = _this$state2.visibleDays,
            dateOffset = _this$state2.dateOffset;
        if (this.isTouchDevice || !hoverDate) return;
        var modifiers = {};
        modifiers = this.deleteModifier(modifiers, hoverDate, 'hovered');

        if (dateOffset) {
          modifiers = this.deleteModifierFromRange(modifiers, dateOffset.start, dateOffset.end, 'hovered-offset');
        }

        if (startDate && !endDate && (0, _isAfterDay["default"])(hoverDate, startDate)) {
          var endSpan = hoverDate.clone().add(1, 'day');
          modifiers = this.deleteModifierFromRange(modifiers, startDate, endSpan, 'hovered-span');
        }

        if (!startDate && endDate && (0, _isAfterDay["default"])(endDate, hoverDate)) {
          modifiers = this.deleteModifierFromRange(modifiers, hoverDate, endDate, 'hovered-span');
        }

        if (startDate && (0, _isSameDay["default"])(day, startDate)) {
          var startSpan = startDate.clone().add(1, 'day');

          var _endSpan4 = startDate.clone().add(minimumNights + 1, 'days');

          modifiers = this.deleteModifierFromRange(modifiers, startSpan, _endSpan4, 'after-hovered-start');
        }

        this.setState({
          hoverDate: null,
          visibleDays: _objectSpread({}, visibleDays, modifiers)
        });
      }

      return onDayMouseLeave;
    }()
  }, {
    key: "onPrevMonthClick",
    value: function () {
      function onPrevMonthClick() {
        var _this$props6 = this.props,
            onPrevMonthClick = _this$props6.onPrevMonthClick,
            numberOfMonths = _this$props6.numberOfMonths,
            enableOutsideDays = _this$props6.enableOutsideDays;
        var _this$state3 = this.state,
            currentMonth = _this$state3.currentMonth,
            visibleDays = _this$state3.visibleDays;
        var newVisibleDays = {};
        Object.keys(visibleDays).sort().slice(0, numberOfMonths + 1).forEach(function (month) {
          newVisibleDays[month] = visibleDays[month];
        });
        var prevMonth = currentMonth.clone().subtract(2, 'months');
        var prevMonthVisibleDays = (0, _getVisibleDays["default"])(prevMonth, 1, enableOutsideDays, true);
        var newCurrentMonth = currentMonth.clone().subtract(1, 'month');
        this.setState({
          currentMonth: newCurrentMonth,
          visibleDays: _objectSpread({}, newVisibleDays, this.getModifiers(prevMonthVisibleDays))
        }, function () {
          onPrevMonthClick(newCurrentMonth.clone());
        });
      }

      return onPrevMonthClick;
    }()
  }, {
    key: "onNextMonthClick",
    value: function () {
      function onNextMonthClick() {
        var _this$props7 = this.props,
            onNextMonthClick = _this$props7.onNextMonthClick,
            numberOfMonths = _this$props7.numberOfMonths,
            enableOutsideDays = _this$props7.enableOutsideDays;
        var _this$state4 = this.state,
            currentMonth = _this$state4.currentMonth,
            visibleDays = _this$state4.visibleDays;
        var newVisibleDays = {};
        Object.keys(visibleDays).sort().slice(1).forEach(function (month) {
          newVisibleDays[month] = visibleDays[month];
        });
        var nextMonth = currentMonth.clone().add(numberOfMonths + 1, 'month');
        var nextMonthVisibleDays = (0, _getVisibleDays["default"])(nextMonth, 1, enableOutsideDays, true);
        var newCurrentMonth = currentMonth.clone().add(1, 'month');
        this.setState({
          currentMonth: newCurrentMonth,
          visibleDays: _objectSpread({}, newVisibleDays, this.getModifiers(nextMonthVisibleDays))
        }, function () {
          onNextMonthClick(newCurrentMonth.clone());
        });
      }

      return onNextMonthClick;
    }()
  }, {
    key: "onMonthChange",
    value: function () {
      function onMonthChange(newMonth) {
        var _this$props8 = this.props,
            numberOfMonths = _this$props8.numberOfMonths,
            enableOutsideDays = _this$props8.enableOutsideDays,
            orientation = _this$props8.orientation;
        var withoutTransitionMonths = orientation === _constants.VERTICAL_SCROLLABLE;
        var newVisibleDays = (0, _getVisibleDays["default"])(newMonth, numberOfMonths, enableOutsideDays, withoutTransitionMonths);
        this.setState({
          currentMonth: newMonth.clone(),
          visibleDays: this.getModifiers(newVisibleDays)
        });
      }

      return onMonthChange;
    }()
  }, {
    key: "onYearChange",
    value: function () {
      function onYearChange(newMonth) {
        var _this$props9 = this.props,
            numberOfMonths = _this$props9.numberOfMonths,
            enableOutsideDays = _this$props9.enableOutsideDays,
            orientation = _this$props9.orientation;
        var withoutTransitionMonths = orientation === _constants.VERTICAL_SCROLLABLE;
        var newVisibleDays = (0, _getVisibleDays["default"])(newMonth, numberOfMonths, enableOutsideDays, withoutTransitionMonths);
        this.setState({
          currentMonth: newMonth.clone(),
          visibleDays: this.getModifiers(newVisibleDays)
        });
      }

      return onYearChange;
    }()
  }, {
    key: "onMultiplyScrollableMonths",
    value: function () {
      function onMultiplyScrollableMonths() {
        var _this$props10 = this.props,
            numberOfMonths = _this$props10.numberOfMonths,
            enableOutsideDays = _this$props10.enableOutsideDays;
        var _this$state5 = this.state,
            currentMonth = _this$state5.currentMonth,
            visibleDays = _this$state5.visibleDays;
        var numberOfVisibleMonths = Object.keys(visibleDays).length;
        var nextMonth = currentMonth.clone().add(numberOfVisibleMonths, 'month');
        var newVisibleDays = (0, _getVisibleDays["default"])(nextMonth, numberOfMonths, enableOutsideDays, true);
        this.setState({
          visibleDays: _objectSpread({}, visibleDays, this.getModifiers(newVisibleDays))
        });
      }

      return onMultiplyScrollableMonths;
    }()
  }, {
    key: "getFirstFocusableDay",
    value: function () {
      function getFirstFocusableDay(newMonth) {
        var _this3 = this;

        var _this$props11 = this.props,
            startDate = _this$props11.startDate,
            endDate = _this$props11.endDate,
            focusedInput = _this$props11.focusedInput,
            minimumNights = _this$props11.minimumNights,
            numberOfMonths = _this$props11.numberOfMonths;
        var focusedDate = newMonth.clone().startOf('month');

        if (focusedInput === _constants.START_DATE && startDate) {
          focusedDate = startDate.clone();
        } else if (focusedInput === _constants.END_DATE && !endDate && startDate) {
          focusedDate = startDate.clone().add(minimumNights, 'days');
        } else if (focusedInput === _constants.END_DATE && endDate) {
          focusedDate = endDate.clone();
        }

        if (this.isBlocked(focusedDate)) {
          var days = [];
          var lastVisibleDay = newMonth.clone().add(numberOfMonths - 1, 'months').endOf('month');
          var currentDay = focusedDate.clone();

          while (!(0, _isAfterDay["default"])(currentDay, lastVisibleDay)) {
            currentDay = currentDay.clone().add(1, 'day');
            days.push(currentDay);
          }

          var viableDays = days.filter(function (day) {
            return !_this3.isBlocked(day);
          });

          if (viableDays.length > 0) {
            var _viableDays = _slicedToArray(viableDays, 1);

            focusedDate = _viableDays[0];
          }
        }

        return focusedDate;
      }

      return getFirstFocusableDay;
    }()
  }, {
    key: "getModifiers",
    value: function () {
      function getModifiers(visibleDays) {
        var _this4 = this;

        var modifiers = {};
        Object.keys(visibleDays).forEach(function (month) {
          modifiers[month] = {};
          visibleDays[month].forEach(function (day) {
            modifiers[month][(0, _toISODateString["default"])(day)] = _this4.getModifiersForDay(day);
          });
        });
        return modifiers;
      }

      return getModifiers;
    }()
  }, {
    key: "getModifiersForDay",
    value: function () {
      function getModifiersForDay(day) {
        var _this5 = this;

        return new Set(Object.keys(this.modifiers).filter(function (modifier) {
          return _this5.modifiers[modifier](day);
        }));
      }

      return getModifiersForDay;
    }()
  }, {
    key: "getStateForNewMonth",
    value: function () {
      function getStateForNewMonth(nextProps) {
        var _this6 = this;

        var initialVisibleMonth = nextProps.initialVisibleMonth,
            numberOfMonths = nextProps.numberOfMonths,
            enableOutsideDays = nextProps.enableOutsideDays,
            orientation = nextProps.orientation,
            startDate = nextProps.startDate;
        var initialVisibleMonthThunk = initialVisibleMonth || (startDate ? function () {
          return startDate;
        } : function () {
          return _this6.today;
        });
        var currentMonth = initialVisibleMonthThunk();
        var withoutTransitionMonths = orientation === _constants.VERTICAL_SCROLLABLE;
        var visibleDays = this.getModifiers((0, _getVisibleDays["default"])(currentMonth, numberOfMonths, enableOutsideDays, withoutTransitionMonths));
        return {
          currentMonth: currentMonth,
          visibleDays: visibleDays
        };
      }

      return getStateForNewMonth;
    }()
  }, {
    key: "addModifier",
    value: function () {
      function addModifier(updatedDays, day, modifier) {
        var _this$props12 = this.props,
            numberOfVisibleMonths = _this$props12.numberOfMonths,
            enableOutsideDays = _this$props12.enableOutsideDays,
            orientation = _this$props12.orientation;
        var _this$state6 = this.state,
            firstVisibleMonth = _this$state6.currentMonth,
            visibleDays = _this$state6.visibleDays;
        var currentMonth = firstVisibleMonth;
        var numberOfMonths = numberOfVisibleMonths;

        if (orientation === _constants.VERTICAL_SCROLLABLE) {
          numberOfMonths = Object.keys(visibleDays).length;
        } else {
          currentMonth = currentMonth.clone().subtract(1, 'month');
          numberOfMonths += 2;
        }

        if (!day || !(0, _isDayVisible["default"])(day, currentMonth, numberOfMonths, enableOutsideDays)) {
          return updatedDays;
        }

        var iso = (0, _toISODateString["default"])(day);

        var updatedDaysAfterAddition = _objectSpread({}, updatedDays);

        if (enableOutsideDays) {
          var monthsToUpdate = Object.keys(visibleDays).filter(function (monthKey) {
            return Object.keys(visibleDays[monthKey]).indexOf(iso) > -1;
          });
          updatedDaysAfterAddition = monthsToUpdate.reduce(function (days, monthIso) {
            var month = updatedDays[monthIso] || visibleDays[monthIso];
            var modifiers = new Set(month[iso]);
            modifiers.add(modifier);
            return _objectSpread({}, days, _defineProperty({}, monthIso, _objectSpread({}, month, _defineProperty({}, iso, modifiers))));
          }, updatedDaysAfterAddition);
        } else {
          var monthIso = (0, _toISOMonthString["default"])(day);
          var month = updatedDays[monthIso] || visibleDays[monthIso];
          var modifiers = new Set(month[iso]);
          modifiers.add(modifier);
          updatedDaysAfterAddition = _objectSpread({}, updatedDaysAfterAddition, _defineProperty({}, monthIso, _objectSpread({}, month, _defineProperty({}, iso, modifiers))));
        }

        return updatedDaysAfterAddition;
      }

      return addModifier;
    }()
  }, {
    key: "addModifierToRange",
    value: function () {
      function addModifierToRange(updatedDays, start, end, modifier) {
        var days = updatedDays;
        var spanStart = start.clone();

        while ((0, _isBeforeDay["default"])(spanStart, end)) {
          days = this.addModifier(days, spanStart, modifier);
          spanStart = spanStart.clone().add(1, 'day');
        }

        return days;
      }

      return addModifierToRange;
    }()
  }, {
    key: "deleteModifier",
    value: function () {
      function deleteModifier(updatedDays, day, modifier) {
        var _this$props13 = this.props,
            numberOfVisibleMonths = _this$props13.numberOfMonths,
            enableOutsideDays = _this$props13.enableOutsideDays,
            orientation = _this$props13.orientation;
        var _this$state7 = this.state,
            firstVisibleMonth = _this$state7.currentMonth,
            visibleDays = _this$state7.visibleDays;
        var currentMonth = firstVisibleMonth;
        var numberOfMonths = numberOfVisibleMonths;

        if (orientation === _constants.VERTICAL_SCROLLABLE) {
          numberOfMonths = Object.keys(visibleDays).length;
        } else {
          currentMonth = currentMonth.clone().subtract(1, 'month');
          numberOfMonths += 2;
        }

        if (!day || !(0, _isDayVisible["default"])(day, currentMonth, numberOfMonths, enableOutsideDays)) {
          return updatedDays;
        }

        var iso = (0, _toISODateString["default"])(day);

        var updatedDaysAfterDeletion = _objectSpread({}, updatedDays);

        if (enableOutsideDays) {
          var monthsToUpdate = Object.keys(visibleDays).filter(function (monthKey) {
            return Object.keys(visibleDays[monthKey]).indexOf(iso) > -1;
          });
          updatedDaysAfterDeletion = monthsToUpdate.reduce(function (days, monthIso) {
            var month = updatedDays[monthIso] || visibleDays[monthIso];
            var modifiers = new Set(month[iso]);
            modifiers["delete"](modifier);
            return _objectSpread({}, days, _defineProperty({}, monthIso, _objectSpread({}, month, _defineProperty({}, iso, modifiers))));
          }, updatedDaysAfterDeletion);
        } else {
          var monthIso = (0, _toISOMonthString["default"])(day);
          var month = updatedDays[monthIso] || visibleDays[monthIso];
          var modifiers = new Set(month[iso]);
          modifiers["delete"](modifier);
          updatedDaysAfterDeletion = _objectSpread({}, updatedDaysAfterDeletion, _defineProperty({}, monthIso, _objectSpread({}, month, _defineProperty({}, iso, modifiers))));
        }

        return updatedDaysAfterDeletion;
      }

      return deleteModifier;
    }()
  }, {
    key: "deleteModifierFromRange",
    value: function () {
      function deleteModifierFromRange(updatedDays, start, end, modifier) {
        var days = updatedDays;
        var spanStart = start.clone();

        while ((0, _isBeforeDay["default"])(spanStart, end)) {
          days = this.deleteModifier(days, spanStart, modifier);
          spanStart = spanStart.clone().add(1, 'day');
        }

        return days;
      }

      return deleteModifierFromRange;
    }()
  }, {
    key: "doesNotMeetMinimumNights",
    value: function () {
      function doesNotMeetMinimumNights(day) {
        var _this$props14 = this.props,
            startDate = _this$props14.startDate,
            isOutsideRange = _this$props14.isOutsideRange,
            focusedInput = _this$props14.focusedInput,
            minimumNights = _this$props14.minimumNights;
        if (focusedInput !== _constants.END_DATE) return false;

        if (startDate) {
          var dayDiff = day.diff(startDate.clone().startOf('day').hour(12), 'days');
          return dayDiff < minimumNights && dayDiff >= 0;
        }

        return isOutsideRange((0, _moment["default"])(day).subtract(minimumNights, 'days'));
      }

      return doesNotMeetMinimumNights;
    }()
  }, {
    key: "isDayAfterHoveredStartDate",
    value: function () {
      function isDayAfterHoveredStartDate(day) {
        var _this$props15 = this.props,
            startDate = _this$props15.startDate,
            endDate = _this$props15.endDate,
            minimumNights = _this$props15.minimumNights;

        var _ref2 = this.state || {},
            hoverDate = _ref2.hoverDate;

        return !!startDate && !endDate && !this.isBlocked(day) && (0, _isNextDay["default"])(hoverDate, day) && minimumNights > 0 && (0, _isSameDay["default"])(hoverDate, startDate);
      }

      return isDayAfterHoveredStartDate;
    }()
  }, {
    key: "isEndDate",
    value: function () {
      function isEndDate(day) {
        var endDate = this.props.endDate;
        return (0, _isSameDay["default"])(day, endDate);
      }

      return isEndDate;
    }()
  }, {
    key: "isHovered",
    value: function () {
      function isHovered(day) {
        var _ref3 = this.state || {},
            hoverDate = _ref3.hoverDate;

        var focusedInput = this.props.focusedInput;
        return !!focusedInput && (0, _isSameDay["default"])(day, hoverDate);
      }

      return isHovered;
    }()
  }, {
    key: "isInHoveredSpan",
    value: function () {
      function isInHoveredSpan(day) {
        var _this$props16 = this.props,
            startDate = _this$props16.startDate,
            endDate = _this$props16.endDate;

        var _ref4 = this.state || {},
            hoverDate = _ref4.hoverDate;

        var isForwardRange = !!startDate && !endDate && (day.isBetween(startDate, hoverDate) || (0, _isSameDay["default"])(hoverDate, day));
        var isBackwardRange = !!endDate && !startDate && (day.isBetween(hoverDate, endDate) || (0, _isSameDay["default"])(hoverDate, day));
        var isValidDayHovered = hoverDate && !this.isBlocked(hoverDate);
        return (isForwardRange || isBackwardRange) && isValidDayHovered;
      }

      return isInHoveredSpan;
    }()
  }, {
    key: "isInSelectedSpan",
    value: function () {
      function isInSelectedSpan(day) {
        var _this$props17 = this.props,
            startDate = _this$props17.startDate,
            endDate = _this$props17.endDate;
        return day.isBetween(startDate, endDate);
      }

      return isInSelectedSpan;
    }()
  }, {
    key: "isLastInRange",
    value: function () {
      function isLastInRange(day) {
        var endDate = this.props.endDate;
        return this.isInSelectedSpan(day) && (0, _isNextDay["default"])(day, endDate);
      }

      return isLastInRange;
    }()
  }, {
    key: "isStartDate",
    value: function () {
      function isStartDate(day) {
        var startDate = this.props.startDate;
        return (0, _isSameDay["default"])(day, startDate);
      }

      return isStartDate;
    }()
  }, {
    key: "isBlocked",
    value: function () {
      function isBlocked(day) {
        var _this$props18 = this.props,
            isDayBlocked = _this$props18.isDayBlocked,
            isOutsideRange = _this$props18.isOutsideRange;
        return isDayBlocked(day) || isOutsideRange(day) || this.doesNotMeetMinimumNights(day);
      }

      return isBlocked;
    }()
  }, {
    key: "isToday",
    value: function () {
      function isToday(day) {
        return (0, _isSameDay["default"])(day, this.today);
      }

      return isToday;
    }()
  }, {
    key: "isFirstDayOfWeek",
    value: function () {
      function isFirstDayOfWeek(day) {
        var firstDayOfWeek = this.props.firstDayOfWeek;
        return day.day() === (firstDayOfWeek || _moment["default"].localeData().firstDayOfWeek());
      }

      return isFirstDayOfWeek;
    }()
  }, {
    key: "isLastDayOfWeek",
    value: function () {
      function isLastDayOfWeek(day) {
        var firstDayOfWeek = this.props.firstDayOfWeek;
        return day.day() === ((firstDayOfWeek || _moment["default"].localeData().firstDayOfWeek()) + 6) % 7;
      }

      return isLastDayOfWeek;
    }()
  }, {
    key: "render",
    value: function () {
      function render() {
        var _this$props19 = this.props,
            numberOfMonths = _this$props19.numberOfMonths,
            orientation = _this$props19.orientation,
            monthFormat = _this$props19.monthFormat,
            renderMonthText = _this$props19.renderMonthText,
            navPrev = _this$props19.navPrev,
            navNext = _this$props19.navNext,
            noNavButtons = _this$props19.noNavButtons,
            onOutsideClick = _this$props19.onOutsideClick,
            withPortal = _this$props19.withPortal,
            enableOutsideDays = _this$props19.enableOutsideDays,
            firstDayOfWeek = _this$props19.firstDayOfWeek,
            hideKeyboardShortcutsPanel = _this$props19.hideKeyboardShortcutsPanel,
            daySize = _this$props19.daySize,
            focusedInput = _this$props19.focusedInput,
            renderCalendarDay = _this$props19.renderCalendarDay,
            renderDayContents = _this$props19.renderDayContents,
            renderCalendarInfo = _this$props19.renderCalendarInfo,
            renderMonthElement = _this$props19.renderMonthElement,
            calendarInfoPosition = _this$props19.calendarInfoPosition,
            onBlur = _this$props19.onBlur,
            onShiftTab = _this$props19.onShiftTab,
            onTab = _this$props19.onTab,
            isFocused = _this$props19.isFocused,
            showKeyboardShortcuts = _this$props19.showKeyboardShortcuts,
            isRTL = _this$props19.isRTL,
            weekDayFormat = _this$props19.weekDayFormat,
            dayAriaLabelFormat = _this$props19.dayAriaLabelFormat,
            verticalHeight = _this$props19.verticalHeight,
            noBorder = _this$props19.noBorder,
            transitionDuration = _this$props19.transitionDuration,
            verticalBorderSpacing = _this$props19.verticalBorderSpacing,
            horizontalMonthPadding = _this$props19.horizontalMonthPadding;
        var _this$state8 = this.state,
            currentMonth = _this$state8.currentMonth,
            phrases = _this$state8.phrases,
            visibleDays = _this$state8.visibleDays;
        return _react["default"].createElement(_DayPicker["default"], {
          orientation: orientation,
          enableOutsideDays: enableOutsideDays,
          modifiers: visibleDays,
          numberOfMonths: numberOfMonths,
          onDayClick: this.onDayClick,
          onDayMouseEnter: this.onDayMouseEnter,
          onDayMouseLeave: this.onDayMouseLeave,
          onPrevMonthClick: this.onPrevMonthClick,
          onNextMonthClick: this.onNextMonthClick,
          onMonthChange: this.onMonthChange,
          onTab: onTab,
          onShiftTab: onShiftTab,
          onYearChange: this.onYearChange,
          onMultiplyScrollableMonths: this.onMultiplyScrollableMonths,
          monthFormat: monthFormat,
          renderMonthText: renderMonthText,
          withPortal: withPortal,
          hidden: !focusedInput,
          initialVisibleMonth: function () {
            function initialVisibleMonth() {
              return currentMonth;
            }

            return initialVisibleMonth;
          }(),
          daySize: daySize,
          onOutsideClick: onOutsideClick,
          navPrev: navPrev,
          navNext: navNext,
          noNavButtons: noNavButtons,
          renderCalendarDay: renderCalendarDay,
          renderDayContents: renderDayContents,
          renderCalendarInfo: renderCalendarInfo,
          renderMonthElement: renderMonthElement,
          calendarInfoPosition: calendarInfoPosition,
          firstDayOfWeek: firstDayOfWeek,
          hideKeyboardShortcutsPanel: hideKeyboardShortcutsPanel,
          isFocused: isFocused,
          getFirstFocusableDay: this.getFirstFocusableDay,
          onBlur: onBlur,
          showKeyboardShortcuts: showKeyboardShortcuts,
          phrases: phrases,
          isRTL: isRTL,
          weekDayFormat: weekDayFormat,
          dayAriaLabelFormat: dayAriaLabelFormat,
          verticalHeight: verticalHeight,
          verticalBorderSpacing: verticalBorderSpacing,
          noBorder: noBorder,
          transitionDuration: transitionDuration,
          horizontalMonthPadding: horizontalMonthPadding
        });
      }

      return render;
    }()
  }]);

  return DayPickerRangeController;
}(_react["default"].PureComponent || _react["default"].Component);

exports["default"] = DayPickerRangeController;
DayPickerRangeController.propTypes = process.env.NODE_ENV !== "production" ? propTypes : {};
DayPickerRangeController.defaultProps = defaultProps;