"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = isDayVisible;

var _moment = _interopRequireDefault(require("moment"));

var _isBeforeDay = _interopRequireDefault(require("./isBeforeDay"));

var _isAfterDay = _interopRequireDefault(require("./isAfterDay"));

var _toISOMonthString = _interopRequireDefault(require("./toISOMonthString"));

var startCacheOutsideDays = new Map();
var endCacheOutsideDays = new Map();
var startCacheInsideDays = new Map();
var endCacheInsideDays = new Map();

function isDayVisible(day, month, numberOfMonths, enableOutsideDays) {
  if (!_moment["default"].isMoment(day)) return false; // Cloning is a little expensive, so we want to do it as little as possible.

  var startKey = (0, _toISOMonthString["default"])(month); // eslint-disable-next-line prefer-template

  var endKey = startKey + '+' + numberOfMonths;

  if (enableOutsideDays) {
    if (!startCacheOutsideDays.has(startKey)) {
      startCacheOutsideDays.set(startKey, month.clone().startOf('month').startOf('week'));
    }

    if ((0, _isBeforeDay["default"])(day, startCacheOutsideDays.get(startKey))) return false;

    if (!endCacheOutsideDays.has(endKey)) {
      endCacheOutsideDays.set(endKey, month.clone().endOf('week').add(numberOfMonths - 1, 'months').endOf('month').endOf('week'));
    }

    return !(0, _isAfterDay["default"])(day, endCacheOutsideDays.get(endKey));
  } // !enableOutsideDays


  if (!startCacheInsideDays.has(startKey)) {
    startCacheInsideDays.set(startKey, month.clone().startOf('month'));
  }

  if ((0, _isBeforeDay["default"])(day, startCacheInsideDays.get(startKey))) return false;

  if (!endCacheInsideDays.has(endKey)) {
    endCacheInsideDays.set(endKey, month.clone().add(numberOfMonths - 1, 'months').endOf('month'));
  }

  return !(0, _isAfterDay["default"])(day, endCacheInsideDays.get(endKey));
}